# VeriTrans4G MDK for Go ver 0.1.6 β

本ソフトウェアは(株)DGフィナンシャルテクノロジーが提供する VeriTrans4G を利用するための MDK (Merchant Development Kit)
、および MDK を利用したサンプルプログラムです。

***

## 動作に必要なソフトウェア

本ソフトウェアのコンパイルおよび実行に必要なソフトウェアは以下の通りです。あらかじめインストールしておく必要があります。

- [Go](https://go.dev/) (1.24.2以降)
- [Playwright fo Go](https://github.com/playwright-community/playwright-go)

本ソフトウェアの編集を行う場合は、以下のような開発ツールをご利用ください。

- [JetBrains GoLand](https://www.jetbrains.com/ja-jp/go/)

## 本ソフトウェアの構成

本ソフトウェアは 3g-mdk-go と main の2つのモジュールで構成されています。

### 3g-mdk-go

MDK 本体です。主に以下の2種類で構成されています。

#### core

VeriTrans4G の決済サーバーに JSON を送信するためのコアプログラム群です。

#### dto

送受信する JSON を marshal または unmarshal する際に利用する各種の構造体が含まれています。

### main

上記 3g-mdk-go を利用したサンプルプログラムです。

| ファイル名         | 内容                   |
|---------------|----------------------|
| main.go       | サンプルの実行および設定を行うプログラム |
| mpi.go        | 本人認証(3Dセキュア2.0)      |
| card.go       | クレジットカード決済           |
| cvs.go        | コンビニ決済               |
| bank.go       | 銀行決済                 |
| paynowid.go   | ワンクリック継続課金サービス       |
| amazonpay.go  | Amazon Pay           |
| carrier.go    | キャリア決済               |
| paypay.go     | PayPay(オンライン決済)      |
| rakuten.go    | 楽天ペイ(オンライン決済)V2      |
| alipayplus.go | Alipay+(オンライン決済)     |

電文のフィールドに関する詳細については、各サービスごとの VeriTrans4G インターフェース詳細 ドキュメントをご参照ください。  
[VeriTrans4G・3Gテスト利用プログラム サポートページ](https://www.veritrans.co.jp/trial/login/4g/)

## 各種設定について

main/main.go にてAPI設定情報をセットしてください。   
マーチャントCCIDおよび認証鍵、Token API Key は[マーチャント管理ポータル(MAP)](https://pay.veritrans.co.jp/maps/)より確認できます。

### main/main.go

```go
const (
MerchantCcId = "{Set Merchant CcId here.}"
MerchantSecret = "{Set Merchant Secret Key here.}"
TokenApiKey = "{Set Token API Key here.}"
...
)
```

また、本サンプルプログラムでは既定でダミー要求(テスト取引)を行うようになっています。

```go
func getConfig() *core.MerchantConfig {
config := core.NewMerchantConfig(MerchantCcId, MerchantSecret)
config.DummyRequest = true
return config
}
```

## サンプルプログラムの実行方法

事前に Go
1.24.2以降がインストールされていることを確認してください。インストールされていない場合は、[Go installation](https://go.dev/doc/install)
を参考にインストールしてください。

```shell
go version
```

```text
go version go1.24.2 linux/amd64
```

また、本サンプルプログラムでは、カード情報を送信してのトークン取得や、画面遷移などのブラウザによる処理を簡易的に再現するため、Playwright
for Go を利用しています。  
main モジュールのディレクトリに移動し、[Installation](https://github.com/playwright-community/playwright-go#installation)
を参考にインストールしてください。

```shell
cd main
go get -u github.com/playwright-community/playwright-go
go run github.com/playwright-community/playwright-go/cmd/playwright@latest install --with-deps
```

main.go にて引数で実行するサンプルを切り替えていますので、以下のようにコマンドを実行してください。

```shell
go run . mpi
```

引数に応じた実行内容は以下の通りです。

| 引数         | 実行内容             |
|------------|------------------|
| mpi        | 本人認証(3Dセキュア2.0)  |
| card       | クレジットカード決済       |
| cvs        | コンビニ決済           |
| bank       | 銀行決済             |
| paynowid   | ワンクリック継続課金サービス   |
| carrier    | キャリア決済           |
| paypay     | PayPay           |
| rakuten    | 楽天ペイV2           |
| alipayplus | Alipay+(オンライン決済) |

***

## 改版履歴

- 2025/05 MDK for Go ver 0.1.6 β リリース
    - Alipay+
        - オンラインに対応
    - PayPay
        - 決済申込の要求電文に以下の項目を追加
            - 支払い可能期限(payTimeoutDatetime)
        - スマートペイメントの集金サービスに対応
    - LINE Payの構造体を削除
    - 依存関係を更新
- 2024/11 MDK for Go ver 0.1.5 β リリース
    - クレジットカード決済/本人認証サービス
      - PCI 3DS対応
          - dddCavv,req3dCavv,res3dCavvがログ上マスクされるように修正
    - PayPay
        - スマートペイメント、バーコード決済対応(部分返金)、authStartUrl対応
    - 依存関係を更新
- 2024/03 MDK for Go ver 0.1.4 β リリース
    - DTOを追加
        - 銀行決済
    - 依存関係を更新
- 2024/03 MDK for Go ver 0.1.3 β リリース
    - 接続先ドメインを新環境(api3.veritrans.co.jp)に変更
    - 依存関係を更新
- 2023/11 MDK for Go Ver 0.1.2 β リリース
    - 3g-mdk-go\dto\Carrier\ReAuthorizeResponse.go にフィールドを追加
        - 取引毎に付くID(CustTxn)
    - 楽天ペイV2:
        - 随時決済に対応
- 2023/10 MDK for Go Ver 0.1.1 β リリース
    - DTOを追加
        - PayPay
        - Amazon Pay
        - 楽天ペイV2
        - LINE Pay
        - キャリア決済
- 2023/09 MDK for Go ver 0.1.0 β リリース

***

##### Copyright 2025 DG Financial Technology,Inc.
