package main

import (
	"3g-mdk-go/core"
	"3g-mdk-go/dto/AmazonPay"
	"3g-mdk-go/dto/Search"
	"context"
	"fmt"
	"github.com/google/uuid"
	"github.com/playwright-community/playwright-go"
	"log/slog"
	"net"
	"net/http"
	"net/http/httptest"
	"os"
)

func amazonpay() {
	handler := http.HandlerFunc(
		func(w http.ResponseWriter, request *http.Request) {
			_, _ = fmt.Fprintln(w, "OK")
		},
	)
	listener, _ := net.Listen("tcp", ":"+LocalServerPort)
	server := httptest.Server{
		Listener: listener,
		Config:   &http.Server{Handler: handler},
	}
	server.Start()
	defer server.Close()

	config := getConfig()

	slog.SetDefault(
		slog.New(
			core.WithWriteTraceIdHandler(
				slog.NewTextHandler(os.Stdout, &slog.HandlerOptions{}),
			),
		),
	)

	redirectionUri := "http://localhost:" + LocalServerPort + "/"

	u, _ := uuid.NewRandom()
	ctx := core.WithTraceID(context.Background(), u.String())

	orderId := "order-" + u.String()

	// AmazonPayAuthorize
	amazonPayAuthorizeRequest := &AmazonPay.AuthorizeRequest{
		OrderId:                     orderId,
		AccountingType:              "0",
		Amount:                      "100",
		WithCapture:                 "false",
		SuppressShippingAddressView: "false",
		SuccessUrl:                  redirectionUri,
		CancelUrl:                   redirectionUri,
		ErrorUrl:                    redirectionUri,
	}

	var amazonPayAuthorizeResponse AmazonPay.AuthorizeResponse
	core.Execute(amazonPayAuthorizeRequest, &amazonPayAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", amazonPayAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", amazonPayAuthorizeResponse.VResultCode)

	if amazonPayAuthorizeResponse.ResponseContents == "" {
		fmt.Println("ResponseContents is empty")
		os.Exit(-1)
	}

	pw, browser, page := openAndMoveBrowser(&html{
		responseContents: amazonPayAuthorizeResponse.ResponseContents,
		sjis:             false,
	})

	_ = page.WaitForLoadState(playwright.PageWaitForLoadStateOptions{State: playwright.LoadStateDomcontentloaded})
	_ = page.Locator("input[type=\"submit\"]").Click()
	_ = page.Locator("input[type=\"submit\"][value=\"続行\"]").Click()
	_ = page.WaitForLoadState(playwright.PageWaitForLoadStateOptions{State: playwright.LoadStateDomcontentloaded})
	_ = page.Locator("button.confirm_btn[type=\"submit\"]").Click()

	_ = page.WaitForURL(redirectionUri)

	closeBrowser(pw, browser, page)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// Search
	searchRequest := &Search.Request{
		ServiceTypeCd:    []string{"amazonpay"},
		ContainDummyFlag: "true",
		SearchParameters: &Search.Parameters{
			Common: &Search.CommonSearchParameter{
				OrderId: orderId,
			},
		},
	}

	var searchResponse Search.Response
	core.Execute(searchRequest, &searchResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", searchResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", searchResponse.VResultCode)
	fmt.Printf("searchCount: %v\n", searchResponse.SearchCount)
	fmt.Printf("overMaxCountFlag: %v\n", searchResponse.OverMaxCountFlag)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AmazonpayGetAddress
	getAddressRequest := &AmazonPay.GetAddressRequest{
		OrderId:         orderId,
		AddInfoRespFlag: "1",
	}

	var getAddressResponse AmazonPay.GetAddressResponse
	core.Execute(getAddressRequest, &getAddressResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", getAddressResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", getAddressResponse.VResultCode)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AmazonPayUpdateAuthorize
	updateAuthorizeRequest := &AmazonPay.UpdateAuthorizeRequest{
		OrderId: orderId,
		Amount:  "200",
	}

	var updateAuthorizeResponse AmazonPay.UpdateAuthorizeResponse
	core.Execute(updateAuthorizeRequest, &updateAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", updateAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", updateAuthorizeResponse.VResultCode)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AmazonPayCapture
	captureRequest := &AmazonPay.CaptureRequest{
		OrderId: orderId,
	}

	var captureResponse AmazonPay.CaptureResponse
	core.Execute(captureRequest, &captureResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", captureResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", captureResponse.VResultCode)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AmazonPayRefund
	refundRequest := &AmazonPay.RefundRequest{
		OrderId: orderId,
	}

	var refundResponse AmazonPay.RefundResponse
	core.Execute(refundRequest, &refundResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", refundResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", refundResponse.VResultCode)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	orderId2 := "order-" + u.String()

	// AmazonPayAuthorize 2
	amazonPayAuthorizeRequest2 := &AmazonPay.AuthorizeRequest{
		OrderId:                     orderId2,
		AccountingType:              "1",
		ConsentAuthType:             "1",
		Amount:                      "100",
		WithCapture:                 "false",
		SuppressShippingAddressView: "false",
		FrequencyUnit:               "Month",
		FrequencyValue:              "1",
		SuccessUrl:                  redirectionUri,
		CancelUrl:                   redirectionUri,
		ErrorUrl:                    redirectionUri,
	}

	var amazonPayAuthorizeResponse2 AmazonPay.AuthorizeResponse
	core.Execute(amazonPayAuthorizeRequest2, &amazonPayAuthorizeResponse2, config, ctx)

	fmt.Printf("mstatus: %s\n", amazonPayAuthorizeResponse2.Mstatus)
	fmt.Printf("vResultCode: %s\n", amazonPayAuthorizeResponse2.VResultCode)

	if amazonPayAuthorizeResponse2.ResponseContents == "" {
		fmt.Printf("ResponseContents is empty")
		os.Exit(-1)
	}

	pw, browser, page = openAndMoveBrowser(&html{
		responseContents: amazonPayAuthorizeResponse2.ResponseContents,
		sjis:             false,
	})

	_ = page.WaitForLoadState(playwright.PageWaitForLoadStateOptions{State: playwright.LoadStateDomcontentloaded})
	_ = page.Locator("input[type=\"submit\"]").Click()
	_ = page.Locator("input[type=\"submit\"][value=\"続行\"]").Click()
	_ = page.WaitForLoadState(playwright.PageWaitForLoadStateOptions{State: playwright.LoadStateDomcontentloaded})
	_ = page.Locator("button.confirm_btn[type=\"submit\"]").Click()

	_ = page.WaitForURL(redirectionUri)

	closeBrowser(pw, browser, page)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AmazonPayUpdateConsent
	updateConsentRequest := &AmazonPay.UpdateConsentRequest{
		OrderId: orderId2,
		Amount:  "200",
	}

	var updateConsentResponse AmazonPay.UpdateConsentResponse
	core.Execute(updateConsentRequest, &updateConsentResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", updateConsentResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", updateConsentResponse.VResultCode)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AmazonPayReAuthorize
	orderId3 := "order-" + u.String()
	reAuthorizeRequest := &AmazonPay.ReAuthorizeRequest{
		OrderId:         orderId3,
		OriginalOrderId: orderId2,
		Amount:          "100",
		WithCapture:     "false",
	}

	var reAuthorizeResponse AmazonPay.ReAuthorizeResponse
	core.Execute(reAuthorizeRequest, &reAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", reAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", reAuthorizeResponse.VResultCode)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AmazonPayCancel
	cancelRequest := &AmazonPay.CancelRequest{
		OrderId: orderId3,
	}

	var cancelResponse AmazonPay.ReAuthorizeResponse
	core.Execute(cancelRequest, &cancelResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", cancelResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", cancelResponse.VResultCode)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AmazonPayTerminate
	terminateRequest := &AmazonPay.TerminateRequest{
		OrderId: orderId2,
	}

	var terminateResponse AmazonPay.TerminateResponse
	core.Execute(terminateRequest, &terminateResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", terminateResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", terminateResponse.VResultCode)

	os.Exit(0)
}
