package main

import (
	"3g-mdk-go/core"
	"3g-mdk-go/dto/Cvs"
	"3g-mdk-go/dto/Search"
	"context"
	"fmt"
	"github.com/google/uuid"
	"log/slog"
	"os"
	"time"
)

func cvs() {

	config := getConfig()

	slog.SetDefault(
		slog.New(
			core.WithWriteTraceIdHandler(
				slog.NewTextHandler(os.Stdout, &slog.HandlerOptions{}),
			),
		),
	)

	u, _ := uuid.NewRandom()
	ctx := core.WithTraceID(context.Background(), u.String())

	orderId := "order-" + u.String()

	payLimit := time.Now().Add(5 * 24 * time.Hour) // + 5 days

	// CvsAuthorize
	CvsAuthorizeRequest := &Cvs.AuthorizeRequest{
		ServiceOptionType: "sej",
		OrderId:           orderId,
		Amount:            "100",
		Name1:             "支払い",
		Name2:             "太郎",
		TelNo:             "090-0000-0000",
		PaymentType:       "0",
		PayLimit:          payLimit.Format("2006/01/02"),
	}

	var CvsAuthorizeResponse Cvs.AuthorizeResponse
	core.Execute(CvsAuthorizeRequest, &CvsAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", CvsAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", CvsAuthorizeResponse.VResultCode)
	fmt.Printf("haraikomiUrl: %s\n", CvsAuthorizeResponse.HaraikomiUrl)
	fmt.Printf("receiptNo: %s\n", CvsAuthorizeResponse.ReceiptNo)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// CvsCancel
	CvsCancelRequest := &Cvs.CancelRequest{
		OrderId: orderId,
	}

	var CvsCancelResponse Cvs.CancelResponse
	core.Execute(CvsCancelRequest, &CvsCancelResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", CvsCancelResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", CvsCancelResponse.VResultCode)

	// Search
	searchRequest := &Search.Request{
		ServiceTypeCd:    []string{"cvs"},
		ContainDummyFlag: "true",
		SearchParameters: &Search.Parameters{
			Common: &Search.CommonSearchParameter{
				OrderId: orderId,
			},
		},
	}

	var searchResponse Search.Response
	core.Execute(searchRequest, &searchResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", searchResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", searchResponse.VResultCode)
	fmt.Printf("searchCount: %v\n", searchResponse.SearchCount)
	fmt.Printf("overMaxCountFlag: %v\n", searchResponse.OverMaxCountFlag)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

}
