package main

import (
	"3g-mdk-go/core"
	"3g-mdk-go/dto/Rakuten"
	"3g-mdk-go/dto/Search"
	"context"
	"fmt"
	"github.com/google/uuid"
	"github.com/playwright-community/playwright-go"
	"log/slog"
	"net"
	"net/http"
	"net/http/httptest"
	"os"
)

func rakuten() {
	handler := http.HandlerFunc(
		func(w http.ResponseWriter, request *http.Request) {
			_, _ = fmt.Fprintln(w, "OK")
		},
	)
	listener, _ := net.Listen("tcp", ":"+LocalServerPort)
	server := httptest.Server{
		Listener: listener,
		Config:   &http.Server{Handler: handler},
	}
	server.Start()
	defer server.Close()

	config := getConfig()

	slog.SetDefault(
		slog.New(
			core.WithWriteTraceIdHandler(
				slog.NewTextHandler(os.Stdout, &slog.HandlerOptions{}),
			),
		),
	)

	redirectionUri := "http://localhost:" + LocalServerPort + "/"

	u, _ := uuid.NewRandom()
	ctx := core.WithTraceID(context.Background(), u.String())

	orderId := "order-" + u.String()

	// RakutenAuthorize
	rakutenAuthorizeRequest := &Rakuten.AuthorizeRequest{
		OrderId:     orderId,
		PayType:     "2",
		Amount:      "100",
		WithCapture: "false",
		SuccessUrl:  redirectionUri,
		ErrorUrl:    redirectionUri,
	}

	var rakutenAuthorizeResponse Rakuten.AuthorizeResponse
	core.Execute(rakutenAuthorizeRequest, &rakutenAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", rakutenAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", rakutenAuthorizeResponse.VResultCode)

	if rakutenAuthorizeResponse.RedirectUrl == "" {
		fmt.Println("RedirectUrl is empty")
		os.Exit(-1)
	}

	pw, browser, page := openBrowser()

	response, err := page.Goto(rakutenAuthorizeResponse.RedirectUrl)
	if response == nil {
		fmt.Println("response is nil")
		os.Exit(-1)
	}
	if err != nil {
		fmt.Printf("An error occurred while navigating to RedirectUrl: %s / Status: %v\n", response.URL(), response.Status())
		os.Exit(-1)
	}

	_ = page.WaitForLoadState(playwright.PageWaitForLoadStateOptions{State: playwright.LoadStateDomcontentloaded})
	_ = page.Locator("input[type=\"submit\"]").Click()
	_ = page.Locator("input[type=\"submit\"]").Click()
	_ = page.WaitForURL(redirectionUri + "*")
	closeBrowser(pw, browser, page)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// Search
	searchRequest := &Search.Request{
		ServiceTypeCd:    []string{"rakuten"},
		ContainDummyFlag: "true",
		SearchParameters: &Search.Parameters{
			Common: &Search.CommonSearchParameter{
				OrderId: orderId,
			},
		},
	}

	var searchResponse Search.Response
	core.Execute(searchRequest, &searchResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", searchResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", searchResponse.VResultCode)
	fmt.Printf("searchCount: %v\n", searchResponse.SearchCount)
	fmt.Printf("overMaxCountFlag: %v\n", searchResponse.OverMaxCountFlag)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// RakutenUpdateAuthorize
	updateAuthorizeRequest := &Rakuten.UpdateAuthorizeRequest{
		OrderId:           orderId,
		AuthExtensionFlag: "true",
	}

	var updateAuthorizeResponse Rakuten.UpdateAuthorizeResponse
	core.Execute(updateAuthorizeRequest, &updateAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", updateAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", updateAuthorizeResponse.VResultCode)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// RakutenCapture
	captureRequest := &Rakuten.CaptureRequest{
		OrderId: orderId,
	}

	var captureResponse Rakuten.CaptureResponse
	core.Execute(captureRequest, &captureResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", captureResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", captureResponse.VResultCode)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// RakutenCancel
	cancelRequest := &Rakuten.CancelRequest{
		OrderId: orderId,
	}

	var cancelResponse Rakuten.CancelResponse
	core.Execute(cancelRequest, &cancelResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", cancelResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", cancelResponse.VResultCode)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	orderId2 := "order-" + u.String()

	// RakutenAuthorize (Test accountingType=1)
	rakutenAuthorizeRequest2 := &Rakuten.AuthorizeRequest{
		OrderId:        orderId2,
		PayType:        "2",
		AccountingType: "1",
		ItemName:       "サンプル商品名",
		SuccessUrl:     redirectionUri,
		ErrorUrl:       redirectionUri,
	}

	var rakutenAuthorizeResponse2 Rakuten.AuthorizeResponse
	core.Execute(rakutenAuthorizeRequest2, &rakutenAuthorizeResponse2, config, ctx)

	fmt.Printf("mstatus: %s\n", rakutenAuthorizeResponse2.Mstatus)
	fmt.Printf("vResultCode: %s\n", rakutenAuthorizeResponse2.VResultCode)

	if rakutenAuthorizeResponse2.RedirectUrl == "" {
		fmt.Printf("RedirectUrl is empty")
		os.Exit(-1)
	}

	pw, browser, page = openBrowser()

	response, err = page.Goto(rakutenAuthorizeResponse2.RedirectUrl)
	if response == nil {
		fmt.Println("response is nil")
		os.Exit(-1)
	}
	if err != nil {
		fmt.Printf("An error occurred while navigating to RedirectUrl: %s / Status: %v", response.URL(), response.Status())
		os.Exit(-1)
	}

	_ = page.WaitForLoadState(playwright.PageWaitForLoadStateOptions{State: playwright.LoadStateDomcontentloaded})
	_ = page.Locator("input[type=\"submit\"]").Click()
	_ = page.Locator("input[type=\"submit\"]").Click()
	_ = page.WaitForURL(redirectionUri + "*")
	closeBrowser(pw, browser, page)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	orderId3 := "order-" + u.String()

	// RakutenReAuthorize
	reAuthorizeRequest := &Rakuten.ReAuthorizeRequest{
		OrderId:         orderId3,
		OriginalOrderId: orderId2,
		Amount:          "100",
		WithCapture:     "false",
	}

	var reAuthorizeResponse Rakuten.ReAuthorizeResponse
	core.Execute(reAuthorizeRequest, &reAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", reAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", reAuthorizeResponse.VResultCode)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// Search (ReAuthorize)
	searchRequest2 := &Search.Request{
		ServiceTypeCd:    []string{"rakuten"},
		ContainDummyFlag: "true",
		SearchParameters: &Search.Parameters{
			Common: &Search.CommonSearchParameter{
				OrderId: orderId3,
			},
		},
	}

	var searchResponse2 Search.Response
	core.Execute(searchRequest2, &searchResponse2, config, ctx)

	fmt.Printf("mstatus: %s\n", searchResponse2.Mstatus)
	fmt.Printf("vResultCode: %s\n", searchResponse2.VResultCode)
	fmt.Printf("searchCount: %v\n", searchResponse2.SearchCount)
	fmt.Printf("overMaxCountFlag: %v\n", searchResponse2.OverMaxCountFlag)

	os.Exit(0)
}
