package main

import (
	"3g-mdk-go/core"
	"3g-mdk-go/dto/Alipayx"
	"3g-mdk-go/dto/Search"
	"context"
	"fmt"
	"github.com/google/uuid"
	"github.com/playwright-community/playwright-go"
	"log/slog"
	"net"
	"net/http"
	"net/http/httptest"
	"os"
)

func alipayplus() {
	handler := http.HandlerFunc(
		func(w http.ResponseWriter, request *http.Request) {
			_, _ = fmt.Fprintln(w, "OK")
		},
	)
	listener, _ := net.Listen("tcp", ":"+LocalServerPort)
	server := httptest.Server{
		Listener: listener,
		Config:   &http.Server{Handler: handler},
	}
	server.Start()
	defer server.Close()

	config := getConfig()

	slog.SetDefault(
		slog.New(
			core.WithWriteTraceIdHandler(
				slog.NewTextHandler(os.Stdout, &slog.HandlerOptions{}),
			),
		),
	)

	redirectionUri := "http://localhost:" + LocalServerPort + "/"

	u, _ := uuid.NewRandom()
	ctx := core.WithTraceID(context.Background(), u.String())

	orderId := "order-" + u.String()

	// AmazonPayAuthorize
	alipayxAuthorizeRequest := &Alipayx.AuthorizeRequest{
		OrderId:           orderId,
		ServiceOptionType: "online",
		Amount:            "100",
		WithCapture:       "true",
		OrderDetail:       "sample_detail",
		DeviceType:        "1",
		UserAgent:         "sample_userAgent(Android)",
		SuccessUrl:        redirectionUri,
		ErrorUrl:          redirectionUri,
	}

	var alipayxAuthorizeResponse Alipayx.AuthorizeResponse
	core.Execute(alipayxAuthorizeRequest, &alipayxAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", alipayxAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", alipayxAuthorizeResponse.VResultCode)

	if alipayxAuthorizeResponse.AuthStartUrl == "" {
		fmt.Println("AuthStartUrl is empty")
		os.Exit(-1)
	}

	pw, browser, page := openBrowser()
	if alipayxAuthorizeResponse.AuthStartUrl != "" {
		_, _ = page.Goto(alipayxAuthorizeResponse.AuthStartUrl)
	}

	_ = page.WaitForLoadState(playwright.PageWaitForLoadStateOptions{State: playwright.LoadStateDomcontentloaded})
	_ = page.GetByRole(*playwright.AriaRoleButton, playwright.PageGetByRoleOptions{Name: "確定"}).Click()
	_ = page.WaitForURL(redirectionUri + "*")
	closeBrowser(pw, browser, page)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// Search
	searchRequest := &Search.Request{
		ServiceTypeCd:    []string{"alipayx"},
		ContainDummyFlag: "true",
		SearchParameters: &Search.Parameters{
			Common: &Search.CommonSearchParameter{
				OrderId: orderId,
			},
		},
	}

	var searchResponse Search.Response
	core.Execute(searchRequest, &searchResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", searchResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", searchResponse.VResultCode)
	fmt.Printf("searchCount: %v\n", searchResponse.SearchCount)
	fmt.Printf("overMaxCountFlag: %v\n", searchResponse.OverMaxCountFlag)

	if len(searchResponse.OrderInfos.OrderInfo) < 1 {
		fmt.Printf("OrderInfo is Empty: %s\n", searchResponse.ResultJson)
		os.Exit(-1)
	}

	// Refund

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AlipayxRefund
	refundRequest := &Alipayx.RefundRequest{
		OrderId:           orderId,
		ServiceOptionType: "online",
	}

	var refundResponse Alipayx.RefundResponse
	core.Execute(refundRequest, &refundResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", refundResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", refundResponse.VResultCode)

}
