package main

import (
	"3g-mdk-go/core"
	"3g-mdk-go/dto/Bank"
	"3g-mdk-go/dto/Search"
	"context"
	"fmt"
	"github.com/google/uuid"
	"log/slog"
	"os"
	"time"
)

func bank() {

	config := getConfig()

	slog.SetDefault(
		slog.New(
			core.WithWriteTraceIdHandler(
				slog.NewTextHandler(os.Stdout, &slog.HandlerOptions{}),
			),
		),
	)

	u, _ := uuid.NewRandom()
	ctx := core.WithTraceID(context.Background(), u.String())

	orderId := "order-" + u.String()

	agreementDate := time.Now()                    //
	payLimit := time.Now().Add(5 * 24 * time.Hour) // + 5 days

	// BankAuthorize
	BankAuthorizeRequest := &Bank.AuthorizeRequest{
		ServiceOptionType: "atm",
		OrderId:           orderId,
		Amount:            "100",
		Name1:             "顧客　氏名",
		Kana1:             "コキャクシメイカナ",
		Post1:             "123",
		Post2:             "4567",
		Address1:          "東京都港区１－６－１",
		TelNo:             "0123456789",
		AgreementDate:     agreementDate.Format("20060102"),
		PayLimit:          payLimit.Format("20060102"),
		Contents:          "表示インフォメーション",
		ContentsKana:      "ヒョウジインフォメーションカナ",
	}

	var BankAuthorizeResponse Bank.AuthorizeResponse
	core.Execute(BankAuthorizeRequest, &BankAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", BankAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", BankAuthorizeResponse.VResultCode)
	fmt.Printf("shunoKikanNo: %s\n", BankAuthorizeResponse.ShunoKikanNo)
	fmt.Printf("customerNo: %s\n", BankAuthorizeResponse.CustomerNo)
	fmt.Printf("confirmNo: %s\n", BankAuthorizeResponse.ConfirmNo)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// Search
	searchRequest := &Search.Request{
		ServiceTypeCd:    []string{"bank"},
		ContainDummyFlag: "true",
		SearchParameters: &Search.Parameters{
			Common: &Search.CommonSearchParameter{
				OrderId: orderId,
			},
		},
	}

	var searchResponse Search.Response
	core.Execute(searchRequest, &searchResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", searchResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", searchResponse.VResultCode)
	fmt.Printf("searchCount: %v\n", searchResponse.SearchCount)
	fmt.Printf("overMaxCountFlag: %v\n", searchResponse.OverMaxCountFlag)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

}
