package main

import (
	"3g-mdk-go/core"
	"3g-mdk-go/dto/Account"
	"3g-mdk-go/dto/CardInfo"
	"3g-mdk-go/dto/PayNowId"
	"context"
	"fmt"
	"github.com/google/uuid"
	"log/slog"
	"os"
)

func paynowid() {

	config := getConfig()

	slog.SetDefault(
		slog.New(
			core.WithWriteTraceIdHandler(
				slog.NewTextHandler(os.Stdout, &slog.HandlerOptions{}),
			),
		),
	)

	token := getToken(VISA)

	u, _ := uuid.NewRandom()
	ctx := core.WithTraceID(context.Background(), u.String())

	accountId := "account-" + u.String()

	// AccountAdd
	accountAddRequest := &Account.AddRequest{
		PayNowIdParam: &PayNowId.Param{
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
				CardParam: &PayNowId.CardParam{
					Token: token,
				},
			},
		},
	}

	var accountAddResponse Account.Response
	core.Execute(accountAddRequest, &accountAddResponse, config, ctx)

	fmt.Printf("accountId: %s\n", accountAddResponse.PayNowIdResponse.Account.AccountId)
	fmt.Printf("mstatus: %s\n", accountAddResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", accountAddResponse.VResultCode)
	fmt.Printf("status: %s\n", accountAddResponse.PayNowIdResponse.Status)
	fmt.Printf("processId: %s\n", accountAddResponse.PayNowIdResponse.ProcessId)
	var cardId1 string
	if len(accountAddResponse.PayNowIdResponse.Account.CardInfo) > 0 {
		cardId1 = accountAddResponse.PayNowIdResponse.Account.CardInfo[0].CardId
		fmt.Printf("cardId: %s\n", cardId1)
	}

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AccountUpdate
	accountUpdateRequest := &Account.UpdateRequest{
		PayNowIdParam: &PayNowId.Param{
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
			},
		},
	}

	var accountUpdateResponse Account.Response
	core.Execute(accountUpdateRequest, &accountUpdateResponse, config, ctx)

	fmt.Printf("accountId: %s\n", accountUpdateResponse.PayNowIdResponse.Account.AccountId)
	fmt.Printf("mstatus: %s\n", accountUpdateResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", accountUpdateResponse.VResultCode)
	fmt.Printf("status: %s\n", accountUpdateResponse.PayNowIdResponse.Status)
	fmt.Printf("processId: %s\n", accountUpdateResponse.PayNowIdResponse.ProcessId)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// CardInfoGet
	cardInfoGetRequest := &CardInfo.GetRequest{
		PayNowIdParam: &PayNowId.Param{
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
			},
		},
	}

	var cardInfoGetResponse CardInfo.Response
	core.Execute(cardInfoGetRequest, &cardInfoGetResponse, config, ctx)

	fmt.Printf("accountId: %s\n", cardInfoGetResponse.PayNowIdResponse.Account.AccountId)
	for i := range cardInfoGetResponse.PayNowIdResponse.Account.CardInfo {
		fmt.Printf("cardId: %s\n", cardInfoGetResponse.PayNowIdResponse.Account.CardInfo[i].CardId)
	}
	fmt.Printf("mstatus: %s\n", cardInfoGetResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", cardInfoGetResponse.VResultCode)
	fmt.Printf("status: %s\n", cardInfoGetResponse.PayNowIdResponse.Status)
	fmt.Printf("processId: %s\n", cardInfoGetResponse.PayNowIdResponse.ProcessId)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	token2 := getToken(MasterCard)

	// CardInfoAdd
	cardInfoAddRequest := &CardInfo.AddRequest{
		PayNowIdParam: &PayNowId.Param{
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
				CardParam: &PayNowId.CardParam{
					Token: token2,
				},
			},
		},
	}

	var cardInfoAddResponse CardInfo.Response
	core.Execute(cardInfoAddRequest, &cardInfoAddResponse, config, ctx)

	fmt.Printf("accountId: %s\n", cardInfoAddResponse.PayNowIdResponse.Account.AccountId)
	for i := range cardInfoAddResponse.PayNowIdResponse.Account.CardInfo {
		fmt.Printf("cardId: %s\n", cardInfoAddResponse.PayNowIdResponse.Account.CardInfo[i].CardId)
	}
	fmt.Printf("mstatus: %s\n", cardInfoAddResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", cardInfoAddResponse.VResultCode)
	fmt.Printf("status: %s\n", cardInfoAddResponse.PayNowIdResponse.Status)
	fmt.Printf("processId: %s\n", cardInfoAddResponse.PayNowIdResponse.ProcessId)
	var cardId2 string
	if len(accountAddResponse.PayNowIdResponse.Account.CardInfo) > 0 {
		cardId2 = accountAddResponse.PayNowIdResponse.Account.CardInfo[0].CardId
		fmt.Printf("cardId: %s\n", cardId2)
	}

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	token3 := getToken(JCB)

	// CardInfoUpdate
	cardInfoUpdateRequest := &CardInfo.UpdateRequest{
		PayNowIdParam: &PayNowId.Param{
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
				CardParam: &PayNowId.CardParam{
					CardId: cardId2,
					Token:  token3,
				},
			},
		},
	}

	var cardInfoUpdateResponse CardInfo.Response
	core.Execute(cardInfoUpdateRequest, &cardInfoUpdateResponse, config, ctx)

	fmt.Printf("accountId: %s\n", cardInfoUpdateResponse.PayNowIdResponse.Account.AccountId)
	for i := range cardInfoUpdateResponse.PayNowIdResponse.Account.CardInfo {
		fmt.Printf("cardId: %s\n", cardInfoUpdateResponse.PayNowIdResponse.Account.CardInfo[i].CardId)
		fmt.Printf("cardNumber: %s\n", cardInfoUpdateResponse.PayNowIdResponse.Account.CardInfo[i].CardNumber)
	}
	fmt.Printf("mstatus: %s\n", cardInfoUpdateResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", cardInfoUpdateResponse.VResultCode)
	fmt.Printf("status: %s\n", cardInfoUpdateResponse.PayNowIdResponse.Status)
	fmt.Printf("processId: %s\n", cardInfoUpdateResponse.PayNowIdResponse.ProcessId)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// CardInfoDelete
	cardInfoDeleteRequest := &CardInfo.DeleteRequest{
		PayNowIdParam: &PayNowId.Param{
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
				CardParam: &PayNowId.CardParam{
					CardId: cardId2,
				},
			},
		},
	}

	var cardInfoDeleteResponse CardInfo.Response
	core.Execute(cardInfoDeleteRequest, &cardInfoDeleteResponse, config, ctx)

	fmt.Printf("accountId: %s\n", cardInfoDeleteResponse.PayNowIdResponse.Account.AccountId)
	fmt.Printf("mstatus: %s\n", cardInfoDeleteResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", cardInfoDeleteResponse.VResultCode)
	fmt.Printf("status: %s\n", cardInfoDeleteResponse.PayNowIdResponse.Status)
	fmt.Printf("processId: %s\n", cardInfoDeleteResponse.PayNowIdResponse.ProcessId)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AccountLink
	accountLinkRequest := &Account.LinkRequest{
		PayNowIdParam: &PayNowId.Param{
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
			},
			OrderParam: &PayNowId.OrderParam{
				OriginalOrderId: "dummyOrderId",
			},
		},
	}

	var accountLinkResponse Account.Response
	core.Execute(accountLinkRequest, &accountLinkResponse, config, ctx)

	fmt.Printf("accountId: %s\n", accountLinkResponse.PayNowIdResponse.Account.AccountId)
	fmt.Printf("mstatus: %s\n", accountLinkResponse.Mstatus) //failure
	fmt.Printf("vResultCode: %s\n", accountLinkResponse.VResultCode)
	fmt.Printf("status: %s\n", accountLinkResponse.PayNowIdResponse.Status)
	fmt.Printf("processId: %s\n", accountLinkResponse.PayNowIdResponse.ProcessId)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AccountDelete
	accountDeleteRequest := &Account.DeleteRequest{
		PayNowIdParam: &PayNowId.Param{
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
			},
		},
	}

	var accountDeleteResponse Account.Response
	core.Execute(accountDeleteRequest, &accountDeleteResponse, config, ctx)

	fmt.Printf("accountId: %s\n", accountDeleteResponse.PayNowIdResponse.Account.AccountId)
	fmt.Printf("mstatus: %s\n", accountDeleteResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", accountDeleteResponse.VResultCode)
	fmt.Printf("status: %s\n", accountDeleteResponse.PayNowIdResponse.Status)
	fmt.Printf("processId: %s\n", accountDeleteResponse.PayNowIdResponse.ProcessId)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AccountRestore
	accountRestoreRequest := &Account.RestoreRequest{
		PayNowIdParam: &PayNowId.Param{
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
			},
		},
	}

	var accountRestoreResponse Account.Response
	core.Execute(accountRestoreRequest, &accountRestoreResponse, config, ctx)

	fmt.Printf("accountId: %s\n", accountRestoreResponse.PayNowIdResponse.Account.AccountId)
	fmt.Printf("mstatus: %s\n", accountRestoreResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", accountRestoreResponse.VResultCode)
	fmt.Printf("status: %s\n", accountRestoreResponse.PayNowIdResponse.Status)
	fmt.Printf("processId: %s\n", accountRestoreResponse.PayNowIdResponse.ProcessId)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// AccountCopy
	accountCopyRequest := &Account.CopyRequest{
		PayNowIdParam: &PayNowId.Param{
			AccountParam: &PayNowId.AccountParam{
				AccountId:         accountId + "_copied",
				OriginalAccountId: accountId,
			},
		},
	}

	var accountCopyResponse Account.Response
	core.Execute(accountCopyRequest, &accountCopyResponse, config, ctx)

	fmt.Printf("accountId: %s\n", accountCopyResponse.PayNowIdResponse.Account.AccountId)
	fmt.Printf("mstatus: %s\n", accountCopyResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", accountCopyResponse.VResultCode)
	fmt.Printf("status: %s\n", accountCopyResponse.PayNowIdResponse.Status)
	fmt.Printf("processId: %s\n", accountCopyResponse.PayNowIdResponse.ProcessId)

}
