package main

import (
	"3g-mdk-go/core"
	"3g-mdk-go/dto/Card"
	"3g-mdk-go/dto/FraudDetectionV2"
	"3g-mdk-go/dto/PayNowId"
	"3g-mdk-go/dto/Search"
	"context"
	"fmt"
	"github.com/google/uuid"
	"log/slog"
	"os"
)

func card() {

	config := getConfig()

	slog.SetDefault(
		slog.New(
			core.WithWriteTraceIdHandler(
				slog.NewTextHandler(os.Stdout, &slog.HandlerOptions{}),
			),
		),
	)

	token := getToken(VISA)

	u, _ := uuid.NewRandom()
	ctx := core.WithTraceID(context.Background(), u.String())

	orderId1 := "order-" + u.String()
	accountId := "account-" + u.String()

	// CardAuthorize
	cardAuthorizeRequest := &Card.AuthorizeRequest{
		OrderId:     orderId1,
		Amount:      "100",
		WithCapture: "false",
		PayNowIdParam: &PayNowId.Param{
			Token: token,
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
			},
		},
	}

	var cardAuthorizeResponse Card.AuthorizeResponse
	core.Execute(cardAuthorizeRequest, &cardAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", cardAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", cardAuthorizeResponse.VResultCode)
	fmt.Printf("cardTransactiontype: %s\n", cardAuthorizeResponse.CardTransactionType)
	fmt.Printf("accountId: %s\n", cardAuthorizeResponse.PayNowIdResponse.Account.AccountId)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// CardCapture
	cardCaptureRequest := &Card.CaptureRequest{
		OrderId: orderId1,
		Amount:  "100",
	}

	var cardCaptureResponse Card.CaptureResponse
	core.Execute(cardCaptureRequest, &cardCaptureResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", cardCaptureResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", cardCaptureResponse.VResultCode)
	fmt.Printf("cardTransactiontype: %s\n", cardCaptureResponse.CardTransactionType)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// CardCancel
	cardCancelRequest := &Card.CancelRequest{
		OrderId: orderId1,
		Amount:  "100",
	}

	var cardCancelResponse Card.CancelResponse
	core.Execute(cardCancelRequest, &cardCancelResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", cardCancelResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", cardCancelResponse.VResultCode)
	fmt.Printf("cardTransactiontype: %s\n", cardCancelResponse.CardTransactionType)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// Search
	searchRequest := &Search.Request{
		ServiceTypeCd:    []string{"card"},
		ContainDummyFlag: "true",
		SearchParameters: &Search.Parameters{
			Common: &Search.CommonSearchParameter{
				OrderId: orderId1,
			},
		},
	}

	var searchResponse Search.Response
	core.Execute(searchRequest, &searchResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", searchResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", searchResponse.VResultCode)
	fmt.Printf("searchCount: %v\n", searchResponse.SearchCount)
	fmt.Printf("overMaxCountFlag: %v\n", searchResponse.OverMaxCountFlag)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	orderId2 := "order-" + u.String()

	// CardReAuthorize
	cardReAuthorizeRequest := &Card.ReAuthorizeRequest{
		OrderId:         orderId2,
		OriginalOrderId: orderId1,
		Amount:          "100",
		WithCapture:     "true",
		PayNowIdParam: &PayNowId.Param{
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
			},
		},
	}

	var cardReAuthorizeResponse Card.ReAuthorizeResponse
	core.Execute(cardReAuthorizeRequest, &cardReAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", cardReAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", cardReAuthorizeResponse.VResultCode)
	fmt.Printf("cardTransactiontype: %s\n", cardReAuthorizeResponse.CardTransactionType)
	fmt.Printf("accountId: %s\n", cardAuthorizeResponse.PayNowIdResponse.Account.AccountId)

}

func fraud() {

	config := getConfig()

	slog.SetDefault(
		slog.New(
			core.WithWriteTraceIdHandler(
				slog.NewTextHandler(os.Stdout, &slog.HandlerOptions{}),
			),
		),
	)

	token := getToken(VISA)

	u, _ := uuid.NewRandom()
	ctx := core.WithTraceID(context.Background(), u.String())

	orderId1 := "order-" + u.String()
	accountId := "account-" + u.String()

	// CardAuthorize
	cardAuthorizeRequest := &Card.AuthorizeRequest{
		OrderId:     orderId1,
		Amount:      "100",
		WithCapture: "false",
		PayNowIdParam: &PayNowId.Param{
			Token: token,
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
			},
		},
		WithFraudDetection: "true",
		FraudDetectionV2Request: &FraudDetectionV2.Request{
			FraudDetectionMode: "3",
			Customer: &FraudDetectionV2.Customer{
				MerchantCustomerId: "USER10001",
				GivenName:          "太郎",
				MiddleName:         "マルクス",
				Surname:            "山田",
				Sex:                "M",
				WorkPhone:          "0612345678",
				BirthDate:          "2000-01-01",
				Phone:              "0312345678",
				Mobile:             "09012345678",
				Email:              "foo@example.com",
				CompanyName:        "株式会社DGフィナンシャルテクノロジー",
				Ip:                 "192.168.1.2",
				BrowserFingerprint: &FraudDetectionV2.BrowserFingerprint{Value: "dummy-finger-print"},
				Status:             "NEW",
			},
			Billing: &FraudDetectionV2.Billing{
				HouseNumber1: "アーバンハウス101",
				Street1:      "渋谷区",
				Street2:      "恵比寿南3-5-7",
				City:         "東京都",
				Country:      "JP",
				Postcode:     "1500022",
			},
			Shipping: &FraudDetectionV2.Shipping{
				Customer: &FraudDetectionV2.Customer{
					MerchantCustomerId: "USER10001",
					GivenName:          "太郎",
					MiddleName:         "マルクス",
					Surname:            "山田",
					Sex:                "M",
					WorkPhone:          "0612345678",
					BirthDate:          "2000-01-01",
					Phone:              "0312345678",
					Mobile:             "09012345678",
					Email:              "foo@example.com",
					CompanyName:        "株式会社DGフィナンシャルテクノロジー",
					Ip:                 "192.168.1.2",
					BrowserFingerprint: &FraudDetectionV2.BrowserFingerprint{Value: "dummy-finger-print"},
					Status:             "NEW",
				},
				HouseNumber1:      "アーバンハウス101",
				Street1:           "渋谷区",
				Street2:           "恵比寿南3-5-7",
				City:              "東京都",
				Country:           "JP",
				Postcode:          "1500022",
				Cost:              "800",
				TrackingNumber:    "1234-5678-9012",
				LogisticsProvider: "O",
				Method:            "OTHER",
			},
			Corporate: &FraudDetectionV2.Corporate{
				Address:       "恵比寿南3-5-7",
				City:          "東京都",
				Fax:           "0312348765",
				Name:          "DG Financial Technology",
				Phone:         "0312345678",
				PostboxNumber: "123",
				PostCode:      "1500022",
				Purchase:      "N",
				Street:        "渋谷区",
				Country:       "JP",
				Suite:         "デジタルゲートビル10F",
			},
			Cart: &FraudDetectionV2.Cart{
				Items: &[]FraudDetectionV2.Item{{
					Quantity:               "1",
					PartNumber:             "4912345678904",
					ProductCode:            "101",
					Sku:                    "10",
					MerchantItemId:         "z12345678",
					Description:            "カレンダー",
					OriginalPrice:          "100",
					ShippingTrackingNumber: "1234-5678-9012",
					GiftMessage:            "DGFT 2022 Calendar",
					ShippingMethod:         "OTHER",
					Type:                   "P",
					RecipientAddress:       "恵比寿南3-5-7",
					RecipientApartment:     "アーバンハウス101",
					RecipientCity:          "東京都",
					RecipientCountry:       "JP",
					RecipientEmail:         "foo@example.com",
					RecipientFirstName:     "太郎",
					RecipientLastName:      "山田",
					RecipientMiddleName:    "マルクス",
					RecipientPhone:         "0312345678",
					RecipientPostcode:      "1500022",
					RecipientStreet:        "渋谷区",
				}},
			},
		},
	}

	var cardAuthorizeResponse Card.AuthorizeResponse
	core.Execute(cardAuthorizeRequest, &cardAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", cardAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", cardAuthorizeResponse.VResultCode)
	fmt.Printf("cardTransactiontype: %s\n", cardAuthorizeResponse.CardTransactionType)
	fmt.Printf("rdResponse.code: %s\n", cardAuthorizeResponse.FraudDetectionResponse.RdResponse.Code)
	fmt.Printf("rdResponse.requestId: %s\n", cardAuthorizeResponse.FraudDetectionResponse.RdResponse.RequestId)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// Search
	searchRequest := &Search.Request{
		ServiceTypeCd:    []string{"card"},
		ContainDummyFlag: "true",
		SearchParameters: &Search.Parameters{
			Common: &Search.CommonSearchParameter{
				OrderId: orderId1,
			},
		},
	}

	var searchResponse Search.Response
	core.Execute(searchRequest, &searchResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", searchResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", searchResponse.VResultCode)
	if len(searchResponse.OrderInfos.OrderInfo) > 0 && len(searchResponse.OrderInfos.OrderInfo[0].TransactionInfos.TransactionInfo) > 0 {
		fmt.Printf("fdResult: %s\n", searchResponse.OrderInfos.OrderInfo[0].TransactionInfos.TransactionInfo[0].ProperTransactionInfo.FdResult)
	}
	fmt.Printf("searchCount: %v\n", searchResponse.SearchCount)
	fmt.Printf("overMaxCountFlag: %v\n", searchResponse.OverMaxCountFlag)

}
