package main

import (
	"3g-mdk-go/core"
	"3g-mdk-go/dto/Mpi"
	"3g-mdk-go/dto/PayNowId"
	"context"
	"fmt"
	"github.com/google/uuid"
	"log/slog"
	"net"
	"net/http"
	"net/http/httptest"
	"os"
)

func mpi() {
	handler := http.HandlerFunc(
		func(w http.ResponseWriter, request *http.Request) {
			_, _ = fmt.Fprintln(w, "OK")
		},
	)
	listener, _ := net.Listen("tcp", ":"+LocalServerPort)
	server := httptest.Server{
		Listener: listener,
		Config:   &http.Server{Handler: handler},
	}
	server.Start()
	defer server.Close()

	config := getConfig()

	slog.SetDefault(
		slog.New(
			core.WithWriteTraceIdHandler(
				slog.NewTextHandler(os.Stdout, &slog.HandlerOptions{}),
			),
		),
	)

	redirectionUri := "http://localhost:" + LocalServerPort + "/"

	token := getToken(VISA)

	u, _ := uuid.NewRandom()
	ctx := core.WithTraceID(context.Background(), u.String())

	orderId1 := "order-" + u.String()
	accountId := "account-" + u.String()

	// MpiAuthorize
	mpiAuthorizeRequest := &Mpi.AuthorizeRequest{
		ServiceOptionType: "mpi-complete",
		OrderId:           orderId1,
		Amount:            "100",
		WithCapture:       "false",
		RedirectionUri:    redirectionUri,
		VerifyResultLink:  "1",
		HttpUserAgent:     "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36 Edg/116.0.1938.62",
		HttpAccept:        "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7",
		DeviceChannel:     "02",
		CardholderEmail:   "foo@example.com",
		PayNowIdParam: &PayNowId.Param{
			Token: token,
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
			},
		},
	}

	var mpiAuthorizeResponse Mpi.AuthorizeResponse
	core.Execute(mpiAuthorizeRequest, &mpiAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", mpiAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", mpiAuthorizeResponse.VResultCode)

	if mpiAuthorizeResponse.AuthStartUrl == "" {
		fmt.Println("AuthStartUrl is empty")
		os.Exit(-1)
	}

	pw, browser, page := openBrowser()

	response, err := page.Goto(mpiAuthorizeResponse.AuthStartUrl)
	if err != nil {
		if response != nil {
			fmt.Printf("An error occurred while navigating to AuthStartUrl: %s / Status: %v\n", response.URL(), response.Status())
		} else {
			fmt.Println("An error occurred while navigating to AuthStartUrl")
		}
		os.Exit(-1)
	}
	err = page.WaitForURL(redirectionUri)
	if err != nil {
		fmt.Printf("The browser did not return to RedirectionUri: %s\n", redirectionUri)
		os.Exit(-1)
	}

	closeBrowser(pw, browser, page)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// MpiGetResult
	mpiGetResultRequest := &Mpi.GetResultRequest{
		OrderId: orderId1,
	}

	var mpiGetResultResponse Mpi.GetResultResponse
	core.Execute(mpiGetResultRequest, &mpiGetResultResponse, config, ctx)

	fmt.Printf("mpiMstatus: %s\n", mpiGetResultResponse.MpiMstatus)
	fmt.Printf("mpiVresultCode: %s\n", mpiGetResultResponse.MpiVresultCode)
	fmt.Printf("cardMstatus: %s\n", mpiGetResultResponse.CardMstatus)
	fmt.Printf("cardTransactionType: %s\n", mpiGetResultResponse.CardTransactionType)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	orderId2 := "order-" + u.String()

	// MpiReAuthorize
	mpiReAuthorizeRequest := &Mpi.ReAuthorizeRequest{
		ServiceOptionType: "mpi-complete",
		OrderId:           orderId2,
		OriginalOrderId:   orderId1,
		Amount:            "300",
		WithCapture:       "true",
		RedirectionUri:    redirectionUri,
		VerifyResultLink:  "1",
		HttpUserAgent:     "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36 Edg/116.0.1938.62",
		HttpAccept:        "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7",
		DeviceChannel:     "02",
		CardholderEmail:   "foo@example.com",
		PayNowIdParam: &PayNowId.Param{
			AccountParam: &PayNowId.AccountParam{
				AccountId: accountId,
			},
		},
	}

	var mpiReAuthorizeResponse Mpi.ReAuthorizeResponse
	core.Execute(mpiReAuthorizeRequest, &mpiReAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", mpiReAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", mpiReAuthorizeResponse.VResultCode)

	if mpiReAuthorizeResponse.AuthStartUrl == "" {
		fmt.Println("AuthStartUrl is empty")
		os.Exit(-1)
	}

	pw, browser, page = openBrowser()

	response, err = page.Goto(mpiReAuthorizeResponse.AuthStartUrl)
	if err != nil {
		if response != nil {
			fmt.Printf("An error occurred while navigating to AuthStartUrl: %s / Status: %v\n", response.URL(), response.Status())
		} else {
			fmt.Println("An error occurred while navigating to AuthStartUrl")
		}
		os.Exit(-1)
	}
	err = page.WaitForURL(redirectionUri)
	if err != nil {
		fmt.Printf("The browser did not return to RedirectionUri: %s", redirectionUri)
		os.Exit(-1)
	}

	closeBrowser(pw, browser, page)

	os.Exit(0)
}
