package main

import (
	"3g-mdk-go/core"
	"3g-mdk-go/dto/PayPay"
	"3g-mdk-go/dto/Search"
	"context"
	"fmt"
	"log/slog"
	"net"
	"net/http"
	"net/http/httptest"
	"os"

	"github.com/google/uuid"
	"github.com/playwright-community/playwright-go"
)

func paypay() {
	handler := http.HandlerFunc(
		func(w http.ResponseWriter, request *http.Request) {
			_, _ = fmt.Fprintln(w, "OK")
		},
	)
	listener, _ := net.Listen("tcp", ":"+LocalServerPort)
	server := httptest.Server{
		Listener: listener,
		Config:   &http.Server{Handler: handler},
	}
	server.Start()
	defer server.Close()

	config := getConfig()
	const authStartUrlOn = true

	slog.SetDefault(
		slog.New(
			core.WithWriteTraceIdHandler(
				slog.NewTextHandler(os.Stdout, &slog.HandlerOptions{}),
			),
		),
	)

	redirectionUri := "http://localhost:" + LocalServerPort + "/"

	u, _ := uuid.NewRandom()
	ctx := core.WithTraceID(context.Background(), u.String())

	orderId1 := "order-" + u.String()

	// PayPayAuthorize (Test accountingType=0)
	paypayAuthorizeRequest := &PayPay.AuthorizeRequest{
		OrderId:           orderId1,
		ServiceOptionType: "online",
		AccountingType:    "0",
		Amount:            "100",
		ItemId:            "payment item",
		SuccessUrl:        redirectionUri,
		CancelUrl:         redirectionUri,
		ErrorUrl:          redirectionUri,
	}

	var paypayAuthorizeResponse PayPay.AuthorizeResponse
	core.Execute(paypayAuthorizeRequest, &paypayAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", paypayAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", paypayAuthorizeResponse.VResultCode)

	pw, browser, page := openBrowser()
	if authStartUrlOn && paypayAuthorizeResponse.AuthStartUrl != "" {
		_, _ = page.Goto(paypayAuthorizeResponse.AuthStartUrl)
	} else {
		// It *MUST* be returned to the browser in the character code *Shift-JIS*.
		moveBrowser(&html{
			responseContents: paypayAuthorizeResponse.ResponseContents,
			sjis:             true,
		}, pw, browser, page)

	}

	_ = page.WaitForLoadState(playwright.PageWaitForLoadStateOptions{State: playwright.LoadStateDomcontentloaded})
	_ = page.Locator("input[type=\"submit\"]").Click()
	_ = page.Locator("input[type=\"submit\"]").Click()
	_ = page.Locator("input[type=\"submit\"]").Click()
	_ = page.WaitForURL(redirectionUri + "*")
	closeBrowser(pw, browser, page)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// Search
	searchRequest := &Search.Request{
		ServiceTypeCd:    []string{"paypay"},
		ContainDummyFlag: "true",
		SearchParameters: &Search.Parameters{
			Common: &Search.CommonSearchParameter{
				OrderId: orderId1,
			},
		},
	}

	var searchResponse Search.Response
	core.Execute(searchRequest, &searchResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", searchResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", searchResponse.VResultCode)
	fmt.Printf("searchCount: %v\n", searchResponse.SearchCount)
	fmt.Printf("overMaxCountFlag: %v\n", searchResponse.OverMaxCountFlag)

	if len(searchResponse.OrderInfos.OrderInfo) < 1 {
		fmt.Printf("OrderInfo is Empty: %s\n", searchResponse.ResultJson)
		os.Exit(-1)
	}

	successDetailTxnType := searchResponse.OrderInfos.OrderInfo[0].SuccessDetailTxnType
	fmt.Printf("successDetailTxnType: %s\n", successDetailTxnType)

	if successDetailTxnType == "AuthCapture" {
		u, _ = uuid.NewRandom()
		ctx = core.WithTraceID(context.Background(), u.String())

		// PayPayRefund
		refundRequest := &PayPay.RefundRequest{
			OrderId:           orderId1,
			ServiceOptionType: "online",
		}

		var refundResponse PayPay.RefundResponse
		core.Execute(refundRequest, &refundResponse, config, ctx)

		fmt.Printf("mstatus: %s\n", refundResponse.Mstatus)
		fmt.Printf("vResultCode: %s\n", refundResponse.VResultCode)
	} else if successDetailTxnType == "Auth" {
		u, _ = uuid.NewRandom()
		ctx = core.WithTraceID(context.Background(), u.String())

		// PayPayCancel
		cancelRequest := &PayPay.CancelRequest{
			OrderId:           orderId1,
			ServiceOptionType: "online",
		}

		var cancelResponse PayPay.CancelResponse
		core.Execute(cancelRequest, &cancelResponse, config, ctx)

		fmt.Printf("mstatus: %s\n", cancelResponse.Mstatus)
		fmt.Printf("vResultCode: %s\n", cancelResponse.VResultCode)
	} else {
		fmt.Printf("Unexpected successDetailTxnType: %s\n", successDetailTxnType)
		os.Exit(-1)
	}

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	orderId2 := "order-" + u.String()

	// PayPayAuthorize (Test accountingType=1)
	paypayAuthorizeRequest2 := &PayPay.AuthorizeRequest{
		OrderId:           orderId2,
		ServiceOptionType: "online",
		AccountingType:    "1",
		ItemId:            "payment item",
		SuccessUrl:        redirectionUri,
		CancelUrl:         redirectionUri,
		ErrorUrl:          redirectionUri,
	}

	var paypayAuthorizeResponse2 PayPay.AuthorizeResponse
	core.Execute(paypayAuthorizeRequest2, &paypayAuthorizeResponse2, config, ctx)

	fmt.Printf("mstatus: %s\n", paypayAuthorizeResponse2.Mstatus)
	fmt.Printf("vResultCode: %s\n", paypayAuthorizeResponse2.VResultCode)

	if paypayAuthorizeResponse2.ResponseContents == "" {
		fmt.Printf("ResponseContents is empty")
		os.Exit(-1)
	}

	pw, browser, page = openBrowser()
	if authStartUrlOn && paypayAuthorizeResponse2.AuthStartUrl != "" {
		_, _ = page.Goto(paypayAuthorizeResponse2.AuthStartUrl)
	} else {
		// It *MUST* be returned to the browser in the character code *Shift-JIS*. (DO)
		moveBrowser(&html{
			responseContents: paypayAuthorizeResponse2.ResponseContents,
			sjis:             true,
		}, pw, browser, page)
	}

	_ = page.WaitForLoadState(playwright.PageWaitForLoadStateOptions{State: playwright.LoadStateDomcontentloaded})
	_ = page.Locator("input[type=\"submit\"]").Click()
	_ = page.Locator("input[type=\"submit\"][value=\"同意\"]").Click()
	_ = page.WaitForURL(redirectionUri + "*")
	closeBrowser(pw, browser, page)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	orderId3 := "order-" + u.String()

	// PayPayReAuthorize
	reAuthorizeRequest := &PayPay.ReAuthorizeRequest{
		OrderId:           orderId3,
		OriginalOrderId:   orderId2,
		ServiceOptionType: "online",
		Amount:            "100",
	}

	var reAuthorizeResponse PayPay.ReAuthorizeResponse
	core.Execute(reAuthorizeRequest, &reAuthorizeResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", reAuthorizeResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", reAuthorizeResponse.VResultCode)

	u, _ = uuid.NewRandom()
	ctx = core.WithTraceID(context.Background(), u.String())

	// PayPayTerminate
	terminateRequest := &PayPay.TerminateRequest{
		OrderId:           orderId2,
		ServiceOptionType: "online",
		Force:             "false",
		SuccessUrl:        redirectionUri,
		CancelUrl:         redirectionUri,
		ErrorUrl:          redirectionUri,
	}

	var terminateResponse PayPay.TerminateResponse
	core.Execute(terminateRequest, &terminateResponse, config, ctx)

	fmt.Printf("mstatus: %s\n", terminateResponse.Mstatus)
	fmt.Printf("vResultCode: %s\n", terminateResponse.VResultCode)

	if terminateResponse.ResponseContents == "" {
		fmt.Printf("ResponseContents is empty")
		os.Exit(-1)
	}

	pw, browser, page = openBrowser()

	if authStartUrlOn && terminateResponse.AuthStartUrl != "" {
		_, _ = page.Goto(terminateResponse.AuthStartUrl)
	} else {
		// It *MUST* be returned to the browser in the character code *Shift-JIS*. (DO)
		moveBrowser(&html{
			responseContents: terminateResponse.ResponseContents,
			sjis:             true,
		}, pw, browser, page)
	}

	_ = page.WaitForLoadState(playwright.PageWaitForLoadStateOptions{State: playwright.LoadStateDomcontentloaded})
	_ = page.Locator("input[type=\"submit\"]").Click()
	_ = page.Locator("input[type=\"submit\"][value=\"同意\"]").Click()
	_ = page.WaitForURL(redirectionUri + "*")
	closeBrowser(pw, browser, page)

	os.Exit(0)
}
