/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk.connection.proxy;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.veritrans.tercerog.mdk.MerchantConfig;
import jp.veritrans.tercerog.mdk.exception.MdkLocalException;
import jp.veritrans.tercerog.mdk.gw.utils.EncryptionUtils;
import jp.veritrans.tercerog.mdk.util.MdkUtil;

public class ProxySocket {
    private Socket proxySocket = null;
    public static final int SEND_MODE_SOAP = 1;
    public static final int SEND_MODE_SERVLET = 2;
    public static Pattern pattern = Pattern.compile("^HTTP/[^ ]* (\\d{3})");

    private ProxySocket() {
    }

    public ProxySocket(int n) throws UnknownHostException, IOException, IllegalArgumentException, Exception {
        this();
        if (1 == n) {
            throw new IllegalArgumentException("SOAP mode is deprecated.");
        }
        if (2 == n) {
            this.setProxySocket();
        }
    }

    private void setProxySocket() throws UnknownHostException, IOException, IllegalArgumentException, Exception {
        block27: {
            FilterOutputStream filterOutputStream = null;
            BufferedReader bufferedReader = null;
            try {
                Object object;
                Object object2;
                MerchantConfig merchantConfig = new MerchantConfig();
                merchantConfig.checkMerchantConfig();
                String string = merchantConfig.getProperty("SERVER_URL");
                String string2 = merchantConfig.getProperty("PROXY_URL");
                String string3 = merchantConfig.getProperty("PROXY_USER_ID");
                String string4 = merchantConfig.getProperty("PROXY_USER_PW");
                int n = merchantConfig.getConnectionTimeout();
                int n2 = merchantConfig.getReadTimeout();
                String[] stringArray = MdkUtil.getHostAndPort(string);
                if (stringArray.length == 0) {
                    throw new MdkLocalException("Invalid proxy url in the config file. ", "MF99");
                }
                String string5 = stringArray[0];
                int n3 = Integer.parseInt(stringArray[1]);
                stringArray = MdkUtil.getHostAndPort(string2);
                String string6 = null;
                int n4 = 0;
                if (stringArray.length != 0) {
                    string6 = stringArray[0];
                    n4 = Integer.parseInt(stringArray[1]);
                }
                if (string6 == null || 0 >= string6.length() || n4 == 0) break block27;
                InetSocketAddress inetSocketAddress = new InetSocketAddress(string6, n4);
                this.proxySocket = new Socket();
                try {
                    this.proxySocket.connect(inetSocketAddress, n);
                }
                catch (Exception exception) {
                    this.proxySocket = null;
                    throw new MdkLocalException("Could not connect to the proxy. " + exception.getMessage(), "MF01", exception);
                }
                this.proxySocket.setSoTimeout(n2);
                filterOutputStream = new DataOutputStream(this.proxySocket.getOutputStream());
                ((DataOutputStream)filterOutputStream).writeBytes("CONNECT " + string5 + ":" + n3 + " HTTP/1.0\r\n");
                if (string3 == null) {
                    string3 = "";
                }
                if (string4 == null) {
                    string4 = "";
                }
                if (string3 != null && 0 < string3.length() || string4 != null && 0 < string4.length()) {
                    object2 = new EncryptionUtils();
                    byte[] byArray = string3.concat(":").concat(string4).getBytes("UTF-8");
                    object = ((EncryptionUtils)object2).base64Enc(byArray);
                    ((DataOutputStream)filterOutputStream).writeBytes("Proxy-Authorization: basic ".concat((String)object).concat("\r\n\r\n"));
                } else {
                    ((DataOutputStream)filterOutputStream).writeBytes("\r\n");
                }
                ((DataOutputStream)filterOutputStream).flush();
                bufferedReader = new BufferedReader(new InputStreamReader(this.proxySocket.getInputStream(), "UTF-8"));
                object2 = bufferedReader.readLine();
                int n5 = 0;
                if (object2 != null && ((Matcher)(object = pattern.matcher((CharSequence)object2))).find()) {
                    n5 = Integer.parseInt(((Matcher)object).group(1));
                }
                if (object2 == null || n5 != 200) {
                    this.proxySocket = null;
                    throw new MdkLocalException("Proxy Authentication failed status:[ " + (String)object2 + " ]", "MF01");
                }
            }
            catch (MdkLocalException mdkLocalException) {
                throw mdkLocalException;
            }
            catch (Exception exception) {
                this.proxySocket = null;
                throw new MdkLocalException("Failed to connect to GW via proxy. " + exception.getMessage(), "MF01", exception);
            }
            finally {
                if (this.proxySocket == null) {
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
            }
        }
    }

    public Socket getProxySocket() {
        return this.proxySocket;
    }
}

