/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk.dto.processor;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLFindHandler
extends DefaultHandler {
    public static final int NO_ARRIVAL = 0;
    public static final int ARRIVAL = 1;
    public static final int ARRIVED = 2;
    private int arrivalStatus;
    private String query;
    private Stack target;
    private Stack stack;
    private StringBuffer sb;
    private static final Pattern pattern = Pattern.compile("[[\\S]]");

    private void initTargetQueue() {
        this.target = new Stack();
        String[] stringArray = this.query.split("/");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
            this.target.push(stringArray[i]);
        }
    }

    public String getResult() {
        return this.sb.toString().trim();
    }

    public XMLFindHandler(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.query = string;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.initTargetQueue();
        this.stack = new Stack();
        this.sb = new StringBuffer();
        this.arrivalStatus = 0;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.stack.push(string3);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string;
        Matcher matcher;
        if (this.arrivalStatus != 2 && this.target.equals(this.stack) && (matcher = pattern.matcher(string = new String(cArray, n, n2))).find()) {
            this.sb.append(string);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.stack.pop();
        if (this.sb.length() > 0) {
            this.arrivalStatus = 2;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.stack.clear();
        this.target.clear();
    }

    public int getArrivalStatus() {
        return this.arrivalStatus;
    }
}

