"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthHashUtil = void 0;
const buffer_1 = require("buffer");
const crypto = require("crypto");
class AuthHashUtil {
    static checkAuthHash(body, merchantCcId, merchantPw) {
        if (!body.hasOwnProperty("authParams") || !body["authParams"]) {
            return false;
        }
        const authParams = body["authParams"];
        if (!body.hasOwnProperty("vAuthInfo") || !body["vAuthInfo"]) {
            return false;
        }
        const vAuthInfo = body["vAuthInfo"];
        const hash = this.createAuthHashInfo(body, authParams, merchantCcId, merchantPw);
        return vAuthInfo == hash;
    }
    static createAuthHashInfo(body, authParams, merchantCcId, merchantPw) {
        const buffer = buffer_1.Buffer.from(authParams, 'base64');
        const decoded = buffer.toString();
        const params = decoded.split(",");
        let str = merchantCcId;
        params.forEach(value => {
            if (body.hasOwnProperty(value)) {
                str += body[value];
            }
        });
        str += merchantPw;
        const sha256 = crypto.createHash('sha256');
        sha256.update(str);
        return sha256.digest('hex');
    }
}
exports.AuthHashUtil = AuthHashUtil;
//# sourceMappingURL=AuthHashUtil.js.map