import {describe} from "mocha"
import assert = require('power-assert');
import {AuthHashUtil} from "../src/tgMdk/AuthHashUtil";

describe('AuthHashUtil Test', () => {

    class body {
        public authParams: string | null | undefined;
        public vAuthInfo: string | null | undefined;

        constructor(authParams: string | null | undefined, vAuthInfo: string | null | undefined) {
            this.authParams = authParams;
            this.vAuthInfo = vAuthInfo;
        }
    }

    const merchantCcId = "A100000000000001000000cc";
    const merchantPw = "abcdef0123456789abcdef0123456789abcdef0123456789abcdef0123456789";

    it("checkAuthHash failure 1", () => {
        const obj = new body("", "");
        const result = AuthHashUtil.checkAuthHash(obj, merchantCcId, merchantPw);
        assert.equal(result, false);
    });

    it("checkAuthHash failure 2", () => {
        const obj = new body(null, null);
        const result = AuthHashUtil.checkAuthHash(obj, merchantCcId, merchantPw);
        assert.equal(result, false);
    });

    it("checkAuthHash failure 3", () => {
        const obj = new body("dummy", null);
        const result = AuthHashUtil.checkAuthHash(obj, merchantCcId, merchantPw);
        assert.equal(result, false);
    });

    it("checkAuthHash failure 4", () => {
        const obj = new body(null, "dummy");
        const result = AuthHashUtil.checkAuthHash(obj, merchantCcId, merchantPw);
        assert.equal(result, false);
    });

    it("checkAuthHash", () => {

        // Set all parameters of the received x-www-form-urlencoded data.
        // Note:There may be other parameters in addition to this.
        const body = {
            RequestId: "YqAkr6wfBVEAAAS@SK0AAAAF",
            OrderId: "order-1654662296",
            reqAmount: "100",
            reqCardNumber: "411111********11",
            reqCurrencyUnit: "",
            mpiMstatus: "success",
            vResultCode: "G011A00100000000",
            cardMstatus: "success",
            cardTransactionType: "a",
            centerRequestDate: "20220608132519",
            centerResponseDate: "20220608132519",
            connectedCenterId: "jcn",
            acquirerCode: "05",
            authCode: "000000",
            tradUrl: "",
            fdResult: "",
            authParams: "ZmRSZXN1bHQsYXV0aENvZGUsUmVxdWVzdElkLG1waU1zdGF0dXMsY2VudGVyUmVxdWVzdERhdGUsY2VudGVyUmVzcG9uc2VEYXRlLE9yZGVySWQscmVxQ2FyZE51bWJlcixjYXJkVHJhbnNhY3Rpb25UeXBlLGNhcmRNc3RhdHVzLHRyYWRVcmwscmVxQ3VycmVuY3lVbml0LGNvbm5lY3RlZENlbnRlcklkLHJlcUFtb3VudCxhY3F1aXJlckNvZGUsdlJlc3VsdENvZGU=",
            vAuthInfo: "27faee59e696f68f9da0a485da1e9a7c827e9308b6a73828366a528e7158938c",
        };

        const result = AuthHashUtil.checkAuthHash(body, merchantCcId, merchantPw);

        assert.equal(result, true);

    });

});
