"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MdkUtil = void 0;
const MerchantConfig_1 = require("./MerchantConfig");
class MdkUtil {
    static maskJson(obj) {
        if (Array.isArray(obj)) {
            this.parseArray(obj);
        }
        else if (typeof obj == "object") {
            this.parseObject(obj);
        }
    }
    static parseObject(obj) {
        for (const key in obj) {
            if (obj.hasOwnProperty(key)) {
                if (Array.isArray(obj[key])) {
                    this.parseArray(obj[key]);
                }
                else if (typeof obj[key] == "object") {
                    this.parseObject(obj[key]);
                }
                else if (typeof obj[key] == "string") {
                    if (MerchantConfig_1.MerchantConfig.isNeedMask(key)) {
                        obj[key] = MdkUtil.getMaskedValue(key, obj[key]);
                    }
                }
            }
        }
    }
    static parseArray(obj) {
        for (const key in obj) {
            if (obj.hasOwnProperty(key)) {
                if (Array.isArray(obj[key])) {
                    this.parseArray(obj[key]);
                }
                else if (typeof obj[key] == "object") {
                    this.parseObject(obj[key]);
                }
                else {
                }
            }
        }
    }
    static getMaskedValue(key, value) {
        if (value == null || value == "") {
            return "";
        }
        if (key.toLowerCase().indexOf("mailaddr") > -1) {
            const index = value.indexOf("@");
            if (index > 0) {
                return "*".repeat(index) + value.substring(index);
            }
            else {
                return value;
            }
        }
        else if (key.toLowerCase().indexOf("cardnumber") > -1) {
            const cardNumber = value.replace(/-/g, "");
            if (cardNumber.length >= 11) {
                return cardNumber.substring(0, 6) + ("*".repeat(cardNumber.length - 10)) + cardNumber.slice(-4);
            }
            else {
                return "*".repeat(cardNumber.length);
            }
        }
        else if (MerchantConfig_1.MerchantConfig.isNeedMask(key)) {
            return "*".repeat(value.length);
        }
        else {
            return value;
        }
    }
    static convertDTOtoJsonObject(dto) {
        if (dto.hasOwnProperty("serviceCommand"))
            delete dto["serviceCommand"];
        if (dto.hasOwnProperty("serviceType"))
            delete dto["serviceType"];
        if (dto.hasOwnProperty("_serviceType"))
            delete dto["_serviceType"];
        return JSON.parse(JSON.stringify(dto));
    }
    static deleteReturn(original) {
        if (!original)
            return "";
        return original.replace("\r\n", "").replace("\n", "");
    }
    static setResponseProperties(resultJson, type) {
        const obj = JSON.parse(resultJson); // 応答JSONをデシリアライズ
        // resultという名前のプロパティが存在することを確認し、
        if (obj.hasOwnProperty("result")) {
            const result = obj["result"]; // resultを取り出す
            delete obj["result"]; // objからresultを削除
            // objからrootレベルのキーを取得(payNowIdResponse, viewResultなど)
            const rootKeys = [];
            for (const key in obj) {
                if (obj.hasOwnProperty(key)) {
                    rootKeys.push(key);
                }
            }
            for (const key in result) {
                if (result.hasOwnProperty(key)) {
                    // rootレベルにキー重複がなければresultのプロパティをobjに追加
                    if (!rootKeys.some(value => value == key)) {
                        obj[key] = result[key];
                    }
                }
            }
            let response = obj;
            let copiedResponse = JSON.parse(JSON.stringify(response));
            MdkUtil.maskJson(copiedResponse);
            response.resultJson = JSON.stringify(copiedResponse); // resultJsonプロパティにマスクしたresponseのJSONを詰める
            return response;
        }
        return new type();
    }
}
exports.MdkUtil = MdkUtil;
//# sourceMappingURL=MdkUtil.js.map