"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MerchantConfig = void 0;
class MerchantConfig {
    host;
    timeout;
    merchantCcId = undefined;
    merchantSecretKey = undefined;
    dummyRequest;
    mdkErrorMode = false;
    allowHttp = false;
    constructor(merchantCcId, merchantSecretKey, dummyRequest = "0", host = "https://api3.veritrans.co.jp:443", timeout = 60, mdkErrorMode = false, allowHttp = false) {
        this.host = host;
        this.timeout = timeout;
        this.merchantCcId = merchantCcId;
        this.merchantSecretKey = merchantSecretKey;
        this.dummyRequest = dummyRequest;
        this.mdkErrorMode = mdkErrorMode;
        this.allowHttp = allowHttp;
    }
    static MASK_ITEM = ["cardNumber", "cardExpire", "birthday", "tel", "firstKanaName",
        "lastKanaName", "mailAddr", "merchantMailAddr", "cancelMailAddr", "name1", "name2", "kana", "kana1", "kana2",
        "telNo", "address1", "address2", "address3", "post1", "post2", "customerNo", "pan", "settleAmount", "exchangeRate",
        "paymentDate", "paymentStatus", "centerTxnId", "shipName", "shipStreet1", "shipStreet2", "shipCity", "shipState",
        "shipCountry", "shipPostalCode", "shipPhone", "reqFirstKanaName", "reqLastKanaName", "reqTel", "reqBirthday",
        "reqCardNumber", "reqCardExpire", "securityCode", "pin", "jis1SecondTrack", "jis2Track", "mailAddress", "firstName",
        "lastName", "recipient", "address", "zip", "emvData", "company", "emailAddress", "phoneNumber", "streetLine",
        "streetLine2", "city", "postal", "birthDate", "mothersMaidenName", "cardHolderName", "hashedCardNumber", "expireDate",
        "comment", "hiraganaId", "email", "mobileEmail", "fullName", "companyName", "departmentName", "mobile", "zipCode",
        "fullKanaName", "customerName", "customerZip", "customerAddress1", "customerAddress2", "customerAddress3", "department",
        "detailName", "shippingName", "shippingPhone", "shippingAddress1", "shippingAddress2", "shippingAddress3", "shippingPrefecture",
        "shippingPostalCode", "buyerId", "buyerEmail", "auId", "identityCode", "billingToken", "oneTimeKey", "authorizationCode",
        "oneTimeCode", "qrCode", "taxiNumber", "taxiDriverName", "taxiDriverMobile", "cardholderName", "cardholderEmail",
        "cardholderHomePhoneCountry", "cardholderHomePhoneNumber", "cardholderMobilePhoneCountry", "cardholderMobilePhoneNumber",
        "cardholderWorkPhoneCountry", "cardholderWorkPhoneNumber", "billingAddressCity", "billingAddressCountry", "billingAddressLine1",
        "billingAddressLine2", "billingAddressLine3", "billingPostalCode", "billingAddressState", "shippingAddressCity",
        "shippingAddressCountry", "shippingAddressLine1", "shippingAddressLine2", "shippingAddressLine3", "shippingPostalCode",
        "shippingAddressState", "customerIp", "deliveryEmailAddress", "holder", "houseNumber1", "street1", "street2", "city",
        "state", "country", "postcode", "address", "fax", "phone", "postboxNumber", "postCode", "street", "suite", "merchantCustomerId",
        "givenName", "middleName", "surname", "workPhone", "ip", "identificationDocId", "recipientAddress", "recipientApartment",
        "recipientCity", "recipientCountry", "recipientEmail", "recipientFirstName", "recipientLastName", "recipientMiddleName",
        "recipientPhone", "recipientPostcode", "recipientSalutation", "recipientState", "recipientStreet", "dob", "frequentFlyerNumber",
        "name", "number", "userName", "userNameKana", "telNumber", "mobileNumber", "emailAddress2", "zipcode", "customerAccessToken",
        "dddCavv", "req3dCavv", "res3dCavv", "cncToken", "memberNum", "cardExp", "qrCodeImgUrl", "qrCodeSmallImgUrl", "qrCodeLargeImgUrl",
        "appPayUrl"];
    static ADD_URL_PAYMENT_VERSION = "v2";
    static ADD_URL_VTID_VERSION = "v1";
    static ADD_URL_PAYMENT = "paynow";
    static ADD_URL_VTID = "paynowid";
    static PAYNOWID_SERVICE_TYPE = ["account", "charge", "recurring", "cardinfo", "bankAccount"];
    static SERVICE_COMMAND_SEARCH = "Search";
    static SEARCH_SERVER = "searchbyid";
    static DUMMY_SERVER = "test";
    static MDK_VERSION = "1.2.8";
    static MDK_DTO_VERSION = "1.2.8";
    static isNeedMask(name) {
        if (name == null)
            return false;
        return MerchantConfig.MASK_ITEM.map(value => value.toLowerCase()).some(value => value == name.toLowerCase());
    }
    static get userAgent() {
        return `VeriTrans 4G MDK/${MerchantConfig.MDK_VERSION}/${MerchantConfig.MDK_DTO_VERSION} (TypeScript)`;
    }
}
exports.MerchantConfig = MerchantConfig;
//# sourceMappingURL=MerchantConfig.js.map