export class MerchantConfig {

    host: string;

    timeout: number;

    merchantCcId: string | undefined = undefined;

    merchantSecretKey: string | undefined = undefined;

    dummyRequest: string;

    mdkErrorMode = false;

    allowHttp = false;

    constructor(merchantCcId: string, merchantSecretKey: string,
                dummyRequest = "0", host = "https://api3.veritrans.co.jp:443", timeout = 60,
                mdkErrorMode = false, allowHttp = false) {
        this.host = host;
        this.timeout = timeout;
        this.merchantCcId = merchantCcId;
        this.merchantSecretKey = merchantSecretKey;
        this.dummyRequest = dummyRequest;
        this.mdkErrorMode = mdkErrorMode;
        this.allowHttp = allowHttp;
    }

    private static readonly MASK_ITEM: Array<string> = ["cardNumber", "cardExpire", "birthday", "tel", "firstKanaName",
        "lastKanaName", "mailAddr", "merchantMailAddr", "cancelMailAddr", "name1", "name2", "kana", "kana1", "kana2",
        "telNo", "address1", "address2", "address3", "post1", "post2", "customerNo", "pan", "settleAmount", "exchangeRate",
        "paymentDate", "paymentStatus", "centerTxnId", "shipName", "shipStreet1", "shipStreet2", "shipCity", "shipState",
        "shipCountry", "shipPostalCode", "shipPhone", "reqFirstKanaName", "reqLastKanaName", "reqTel", "reqBirthday",
        "reqCardNumber", "reqCardExpire", "securityCode", "pin", "jis1SecondTrack", "jis2Track", "mailAddress", "firstName",
        "lastName", "recipient", "address", "zip", "emvData", "company", "emailAddress", "phoneNumber", "streetLine",
        "streetLine2", "city", "postal", "birthDate", "mothersMaidenName", "cardHolderName", "hashedCardNumber", "expireDate",
        "comment", "hiraganaId", "email", "mobileEmail", "fullName", "companyName", "departmentName", "mobile", "zipCode",
        "fullKanaName", "customerName", "customerZip", "customerAddress1", "customerAddress2", "customerAddress3", "department",
        "detailName", "shippingName", "shippingPhone", "shippingAddress1", "shippingAddress2", "shippingAddress3", "shippingPrefecture",
        "shippingPostalCode", "buyerId", "buyerEmail", "auId", "identityCode", "billingToken", "oneTimeKey", "authorizationCode",
        "oneTimeCode", "qrCode", "taxiNumber", "taxiDriverName", "taxiDriverMobile", "cardholderName", "cardholderEmail",
        "cardholderHomePhoneCountry", "cardholderHomePhoneNumber", "cardholderMobilePhoneCountry", "cardholderMobilePhoneNumber",
        "cardholderWorkPhoneCountry", "cardholderWorkPhoneNumber", "billingAddressCity", "billingAddressCountry", "billingAddressLine1",
        "billingAddressLine2", "billingAddressLine3", "billingPostalCode", "billingAddressState", "shippingAddressCity",
        "shippingAddressCountry", "shippingAddressLine1", "shippingAddressLine2", "shippingAddressLine3", "shippingPostalCode",
        "shippingAddressState", "customerIp", "deliveryEmailAddress", "holder", "houseNumber1", "street1", "street2", "city",
        "state", "country", "postcode", "address", "fax", "phone", "postboxNumber", "postCode", "street", "suite", "merchantCustomerId",
        "givenName", "middleName", "surname", "workPhone", "ip", "identificationDocId", "recipientAddress", "recipientApartment",
        "recipientCity", "recipientCountry", "recipientEmail", "recipientFirstName", "recipientLastName", "recipientMiddleName",
        "recipientPhone", "recipientPostcode", "recipientSalutation", "recipientState", "recipientStreet", "dob", "frequentFlyerNumber",
        "name", "number", "userName", "userNameKana", "telNumber", "mobileNumber", "emailAddress2", "zipcode", "customerAccessToken",
        "dddCavv", "req3dCavv", "res3dCavv", "cncToken", "memberNum", "cardExp", "qrCodeImgUrl", "qrCodeSmallImgUrl", "qrCodeLargeImgUrl",
        "appPayUrl"];

    public static readonly ADD_URL_PAYMENT_VERSION: string = "v2";
    public static readonly ADD_URL_VTID_VERSION: string = "v1";
    public static readonly ADD_URL_PAYMENT: string = "paynow";
    public static readonly ADD_URL_VTID: string = "paynowid";
    public static readonly PAYNOWID_SERVICE_TYPE: Array<string> =
        ["account", "charge", "recurring", "cardinfo", "bankAccount"];
    public static readonly SERVICE_COMMAND_SEARCH: string = "Search";
    public static readonly SEARCH_SERVER: string = "searchbyid";
    public static readonly DUMMY_SERVER: string = "test";
    public static readonly MDK_VERSION: string = "1.2.8";
    public static readonly MDK_DTO_VERSION: string = "1.2.8";

    public static isNeedMask(name: string | undefined | null): boolean {
        if (name == null) return false;
        return MerchantConfig.MASK_ITEM.map(value => value.toLowerCase()).some(value => value == name.toLowerCase());
    }

    public static get userAgent(): string {
        return `VeriTrans 4G MDK/${MerchantConfig.MDK_VERSION}/${MerchantConfig.MDK_DTO_VERSION} (TypeScript)`;
    }
}
