import {AbstractPaymentCreditRequestDto} from "./AbstractPaymentCreditRequestDto";
import {OptionParam} from "../OptionParam";
import {FraudDetectionRequestDto} from "../FraudDetection/FraudDetectionRequestDto";
import {IRequestDto} from "../../tgMdk/IRequestDto";
import {FraudDetectionV2RequestDto} from "../FraudDetectionV2/FraudDetectionV2RequestDto";


export class CardAuthorizeRequestDto extends AbstractPaymentCreditRequestDto implements IRequestDto {
    readonly serviceType: string = "card";
    readonly serviceCommand: string = "Authorize";


    orderId: string;


    amount: string;


    cardNumber: string;


    cardExpire: string;


    cardOptionType: string;


    cardCenter: string;


    acquirerCode: string;


    jpo: string;


    withCapture: string;


    salesDay: string;


    itemCode: string;


    dddMessageVersion: string;


    dddTransactionId: string;


    dddTransactionStatus: string;


    dddCavvAlgorithm: string;


    dddCavv: string;


    dddEci: string;


    dddDsTransactionId: string;


    dddServerTransactionId: string;


    securityCode: string;


    authFlag: string;


    birthday: string;


    tel: string;


    firstKanaName: string;


    lastKanaName: string;


    currencyUnit: string;


    pin: string;


    paymentType: string;


    jis1SecondTrack: string;


    jis2Track: string;


    firstPayment: string;


    bonusFirstPayment: string;


    mcAmount: string;


    posDataCode: string;


    terminalId: string;


    fraudDetectionRequest: FraudDetectionRequestDto;


    fraudDetectionV2Request: FraudDetectionV2RequestDto;


    withFraudDetection: string;


    chipConditionCode: string;


    withJcnTokenization: string;


    jcnToken: string;


    jcnTokenVersion: string;


    exSlipInfo: string;


    optionParams: OptionParam[];

    private _maskedLog: string;

    get maskedLog(): string {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }

}
