import {IRequestDto} from "../../tgMdk/IRequestDto";
import {AbstractPaymentRequestDto} from "../AbstractPaymentRequestDto";
import type {PaypayProductDto} from "./PaypayProductDto";


export class PaypayRefundRequestDto extends AbstractPaymentRequestDto implements IRequestDto {
    readonly serviceType: string = "paypay";
    readonly serviceCommand: string = "Refund";


    orderId: string;


    serviceOptionType: string;


    storeId: string;


    terminalId: string;


    receiptNumber: string;


    settleBizCode: string;


    amount: string;


    reason: string;


    products: PaypayProductDto[];


    private _maskedLog: string;

    get maskedLog(): string {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }

}

