"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpClient = void 0;
const MerchantConfig_1 = require("./MerchantConfig");
const node_fetch_1 = require("node-fetch");
class HttpClient {
    _config;
    constructor(config) {
        this._config = config;
    }
    async execute(uri, json) {
        const headers = {
            'Content-Type': 'application/x-www-form-urlencoded',
            'User-Agent': MerchantConfig_1.MerchantConfig.userAgent
        };
        let options = {
            method: 'post',
            headers: headers,
            body: encodeURIComponent(json),
            timeout: this._config.timeout * 1000,
        };
        const res = await (0, node_fetch_1.default)(uri, options);
        return res.ok ? res : Promise.reject(res);
    }
}
exports.HttpClient = HttpClient;
//# sourceMappingURL=HttpClient.js.map