"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MerchantUtility = void 0;
const buffer_1 = require("buffer");
const crypto = require("crypto");
class MerchantUtility {
    static checkMessage(secretKey, msgBody, sContentHmac) {
        if (!secretKey || !msgBody || !sContentHmac) {
            return false;
        }
        const delimiter = ";v=";
        const hmacPos = sContentHmac.indexOf(delimiter);
        if (hmacPos < 0) {
            return false;
        }
        const paramHmac = sContentHmac.substring(hmacPos + delimiter.length);
        const hmacSHA256 = crypto.createHmac('sha256', buffer_1.Buffer.from(secretKey, 'hex'));
        hmacSHA256.update(buffer_1.Buffer.from(msgBody, 'utf8'));
        const hmac = hmacSHA256.digest('hex');
        return !(!hmac || hmac != paramHmac);
    }
}
exports.MerchantUtility = MerchantUtility;
//# sourceMappingURL=MerchantUtility.js.map