"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractPayNowIdRequestDto = void 0;
const MdkDtoBase_1 = require("../MdkDtoBase");
const PayNowIdParam_1 = require("./PayNowIdParam");
const AccountParam_1 = require("./AccountParam");
const ChargeParam_1 = require("./ChargeParam");
const AccountBasicParam_1 = require("./AccountBasicParam");
const CardParam_1 = require("./CardParam");
const RecurringChargeParam_1 = require("./RecurringChargeParam");
const BankAccountParam_1 = require("./BankAccountParam");
const OrderParam_1 = require("./OrderParam");
const PayNowIdConstants_1 = require("./PayNowIdConstants");
class AbstractPayNowIdRequestDto extends MdkDtoBase_1.MdkDtoBase {
    constructor(serviceType) {
        super();
        this._serviceType = serviceType;
    }
    _serviceType;
    payNowIdParam;
    get accountId() {
        this.existAccountParam();
        return this.payNowIdParam.accountParam.accountId;
    }
    set accountId(value) {
        this.existAccountParam();
        this.payNowIdParam.accountParam.accountId = value;
    }
    get onetimeToken() {
        return this.payNowIdParam.accountParam.onetimeToken;
    }
    set onetimeToken(value) {
        this.existAccountParam();
        this.payNowIdParam.accountParam.onetimeToken = value;
    }
    get onetimeTokenType() {
        return this.payNowIdParam.accountParam.onetimeTokenType;
    }
    set onetimeTokenType(value) {
        this.existAccountParam();
        this.payNowIdParam.accountParam.onetimeTokenType = value;
    }
    get originalAccountId() {
        return this.payNowIdParam.accountParam.originalAccountId;
    }
    set originalAccountId(value) {
        this.existAccountParam();
        this.payNowIdParam.accountParam.originalAccountId = value;
    }
    get payNowId() {
        this.existAccountParam();
        return this.payNowIdParam.accountParam.payNowId;
    }
    set payNowId(value) {
        this.existAccountParam();
        this.payNowIdParam.accountParam.payNowId = value;
    }
    get transData() {
        this.existAccountParam();
        return this.payNowIdParam.accountParam.transData;
    }
    set transData(value) {
        this.existAccountParam();
        this.payNowIdParam.accountParam.transData = value;
    }
    get createDate() {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.createDate;
    }
    set createDate(value) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.createDate = value;
    }
    get deleteDate() {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.deleteDate;
    }
    set deleteDate(value) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.deleteDate = value;
    }
    get forceDeleteDate() {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.forceDeleteDate;
    }
    set forceDeleteDate(value) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.forceDeleteDate = value;
    }
    get deleteCardInfo() {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.deleteCardInfo;
    }
    set deleteCardInfo(value) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.deleteCardInfo = value;
    }
    get addCardInfo() {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.addCardInfo;
    }
    set addCardInfo(value) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.addCardInfo = value;
    }
    get deleteOriginalAccountId() {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.deleteOriginalAccountId;
    }
    set deleteOriginalAccountId(value) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.deleteOriginalAccountId = value;
    }
    get defaultCardOnly() {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.defaultCardOnly;
    }
    set defaultCardOnly(value) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.defaultCardOnly = value;
    }
    get cleaningConfig() {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.cleaningConfig;
    }
    set cleaningConfig(value) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.cleaningConfig = value;
    }
    get cardId() {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.cardId;
    }
    set cardId(value) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.cardId = value;
    }
    get defaultCard() {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.defaultCard;
    }
    set defaultCard(value) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.defaultCard = value;
    }
    get defaultCardId() {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.defaultCardId;
    }
    set defaultCardId(value) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.defaultCardId = value;
    }
    get updater() {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.updater;
    }
    set updater(value) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.updater = value;
    }
    get cardNumber() {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.cardNumber;
    }
    set cardNumber(value) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.cardNumber = value;
    }
    get cardExpire() {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.cardExpire;
    }
    set cardExpire(value) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.cardExpire = value;
    }
    get cardholderName() {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.cardholderName;
    }
    set cardholderName(value) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.cardholderName = value;
    }
    get token() {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.token;
    }
    set token(value) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.token = value;
    }
    get cardNumberMaskType() {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.cardNumberMaskType;
    }
    set cardNumberMaskType(value) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.cardNumberMaskType = value;
    }
    get withAuthorize() {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.withAuthorize;
    }
    set withAuthorize(value) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.withAuthorize = value;
    }
    get securityCode() {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.securityCode;
    }
    set securityCode(value) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.securityCode = value;
    }
    get groupId() {
        let groupId = null;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            this.existRecurringChargeParam();
            groupId = this.payNowIdParam.accountParam.recurringChargeParam.groupId;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            this.existChargeParam();
            groupId = this.payNowIdParam.chargeParam.groupId;
        }
        return groupId;
    }
    set groupId(value) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam();
            this.payNowIdParam.accountParam.recurringChargeParam.groupId = value;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam();
            this.payNowIdParam.chargeParam.groupId = value;
        }
    }
    get startDate() {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.startDate;
    }
    set startDate(value) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.startDate = value;
    }
    get endDate() {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.endDate;
    }
    set endDate(value) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.endDate = value;
    }
    get finalCharge() {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.finalCharge;
    }
    set finalCharge(value) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.finalCharge = value;
    }
    get recurringMemo1() {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.recurringMemo1;
    }
    set recurringMemo1(value) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.recurringMemo1 = value;
    }
    get recurringMemo2() {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.recurringMemo2;
    }
    set recurringMemo2(value) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.recurringMemo2 = value;
    }
    get recurringMemo3() {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.recurringMemo3;
    }
    set recurringMemo3(value) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.recurringMemo3 = value;
    }
    get useChargeOption() {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.useChargeOption;
    }
    set useChargeOption(value) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.useChargeOption = value;
    }
    get salesDay() {
        let salesDay = null;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            this.existRecurringChargeParam();
            salesDay = this.payNowIdParam.accountParam.recurringChargeParam.salesDay;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            this.existChargeParam();
            salesDay = this.payNowIdParam.chargeParam.salesDay;
        }
        return salesDay;
    }
    set salesDay(value) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam();
            this.payNowIdParam.accountParam.recurringChargeParam.salesDay = value;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam();
            this.payNowIdParam.chargeParam.salesDay = value;
        }
    }
    get acquireCode() {
        let acquireCode = null;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            this.existRecurringChargeParam();
            acquireCode = this.payNowIdParam.accountParam.recurringChargeParam.acquireCode;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            this.existChargeParam();
            acquireCode = this.payNowIdParam.chargeParam.acquireCode;
        }
        return acquireCode;
    }
    set acquireCode(value) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam();
            this.payNowIdParam.accountParam.recurringChargeParam.acquireCode = value;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam();
            this.payNowIdParam.chargeParam.acquireCode = value;
        }
    }
    get oneTimeAmount() {
        let oneTimeAmount = null;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            this.existRecurringChargeParam();
            oneTimeAmount = this.payNowIdParam.accountParam.recurringChargeParam.oneTimeAmount;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            this.existChargeParam();
            oneTimeAmount = this.payNowIdParam.chargeParam.oneTimeAmount;
        }
        return oneTimeAmount;
    }
    set oneTimeAmount(value) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam();
            this.payNowIdParam.accountParam.recurringChargeParam.oneTimeAmount = value;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam();
            this.payNowIdParam.chargeParam.oneTimeAmount = value;
        }
    }
    get amount() {
        let amount = null;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            this.existRecurringChargeParam();
            amount = this.payNowIdParam.accountParam.recurringChargeParam.amount;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            this.existChargeParam();
            amount = this.payNowIdParam.chargeParam.amount;
        }
        return amount;
    }
    set amount(value) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam();
            this.payNowIdParam.accountParam.recurringChargeParam.amount = value;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam();
            this.payNowIdParam.chargeParam.amount = value;
        }
    }
    get bankCode() {
        this.existBankAccountParam();
        return this.payNowIdParam.accountParam.bankAccountParam.bankCode;
    }
    set bankCode(value) {
        this.existBankAccountParam();
        this.payNowIdParam.accountParam.bankAccountParam.bankCode = value;
    }
    get branchCode() {
        this.existBankAccountParam();
        return this.payNowIdParam.accountParam.bankAccountParam.branchCode;
    }
    set branchCode(value) {
        this.existBankAccountParam();
        this.payNowIdParam.accountParam.bankAccountParam.branchCode = value;
    }
    get accountType() {
        this.existBankAccountParam();
        return this.payNowIdParam.accountParam.bankAccountParam.accountType;
    }
    set accountType(value) {
        this.existBankAccountParam();
        this.payNowIdParam.accountParam.bankAccountParam.accountType = value;
    }
    get accountNumber() {
        this.existBankAccountParam();
        return this.payNowIdParam.accountParam.bankAccountParam.accountNumber;
    }
    set accountNumber(value) {
        this.existBankAccountParam();
        this.payNowIdParam.accountParam.bankAccountParam.accountNumber = value;
    }
    get accountManageType() {
        this.existBankAccountParam();
        return this.payNowIdParam.accountParam.bankAccountParam.accountManageType;
    }
    set accountManageType(value) {
        this.existBankAccountParam();
        this.payNowIdParam.accountParam.bankAccountParam.accountManageType = value;
    }
    get rejectBankAccount() {
        this.existBankAccountParam();
        return this.payNowIdParam.accountParam.bankAccountParam.rejectBankAccount;
    }
    set rejectBankAccount(value) {
        this.existBankAccountParam();
        this.payNowIdParam.accountParam.bankAccountParam.rejectBankAccount = value;
    }
    get groupName() {
        this.existChargeParam();
        return this.payNowIdParam.chargeParam.groupName;
    }
    set groupName(value) {
        this.existChargeParam();
        this.payNowIdParam.chargeParam.groupName = value;
    }
    get type() {
        this.existChargeParam();
        return this.payNowIdParam.chargeParam.type;
    }
    set type(value) {
        this.existChargeParam();
        this.payNowIdParam.chargeParam.type = value;
    }
    get chargeType() {
        this.existChargeParam();
        return this.payNowIdParam.chargeParam.chargeType;
    }
    set chargeType(value) {
        this.existChargeParam();
        this.payNowIdParam.chargeParam.chargeType = value;
    }
    get schedule() {
        this.existChargeParam();
        return this.payNowIdParam.chargeParam.schedule;
    }
    set schedule(value) {
        this.existChargeParam();
        this.payNowIdParam.chargeParam.schedule = value;
    }
    get tanking() {
        this.existPayNowIdParam();
        return this.payNowIdParam.tanking;
    }
    set tanking(value) {
        this.existPayNowIdParam();
        this.payNowIdParam.tanking = value;
    }
    get originalOrderId() {
        this.existOrderParam();
        return this.payNowIdParam.orderParam.originalOrderId;
    }
    set originalOrderId(value) {
        this.existOrderParam();
        this.payNowIdParam.orderParam.originalOrderId = value;
    }
    get cleaningMerchantId() {
        this.existOrderParam();
        return this.payNowIdParam.orderParam.cleaningMerchantId;
    }
    set cleaningMerchantId(value) {
        this.existOrderParam();
        this.payNowIdParam.orderParam.cleaningMerchantId = value;
    }
    isRecurring() {
        return (PayNowIdConstants_1.PayNowIdConstants.SERVICE_TYPE_ACCOUNT == this._serviceType ||
            PayNowIdConstants_1.PayNowIdConstants.SERVICE_TYPE_RECURRING == this._serviceType);
    }
    isCharge() {
        return (PayNowIdConstants_1.PayNowIdConstants.SERVICE_TYPE_CHARGE == this._serviceType);
    }
    existPayNowIdParam() {
        if (this.payNowIdParam == null) {
            this.payNowIdParam = new PayNowIdParam_1.PayNowIdParam();
        }
    }
    existAccountParam() {
        this.existPayNowIdParam();
        if (this.payNowIdParam.accountParam == null) {
            this.payNowIdParam.accountParam = new AccountParam_1.AccountParam();
        }
    }
    existAccountBasicParam() {
        this.existAccountParam();
        if (this.payNowIdParam.accountParam.accountBasicParam == null) {
            this.payNowIdParam.accountParam.accountBasicParam = new AccountBasicParam_1.AccountBasicParam();
        }
    }
    existCardParam() {
        this.existAccountParam();
        if (this.payNowIdParam.accountParam.cardParam == null) {
            this.payNowIdParam.accountParam.cardParam = new CardParam_1.CardParam();
        }
    }
    existRecurringChargeParam() {
        this.existAccountParam();
        if (this.payNowIdParam.accountParam.recurringChargeParam == null) {
            this.payNowIdParam.accountParam.recurringChargeParam = new RecurringChargeParam_1.RecurringChargeParam();
        }
    }
    existChargeParam() {
        this.existPayNowIdParam();
        if (this.payNowIdParam.chargeParam == null) {
            this.payNowIdParam.chargeParam = new ChargeParam_1.ChargeParam();
        }
    }
    existBankAccountParam() {
        this.existAccountParam();
        if (this.payNowIdParam.accountParam.bankAccountParam == null) {
            this.payNowIdParam.accountParam.bankAccountParam = new BankAccountParam_1.BankAccountParam();
        }
    }
    existOrderParam() {
        this.existPayNowIdParam();
        if (this.payNowIdParam.orderParam == null) {
            this.payNowIdParam.orderParam = new OrderParam_1.OrderParam();
        }
    }
}
exports.AbstractPayNowIdRequestDto = AbstractPayNowIdRequestDto;
//# sourceMappingURL=AbstractPayNowIdRequestDto.js.map