import {MdkDtoBase} from "../MdkDtoBase";
import {PayNowIdParam} from "./PayNowIdParam";
import {AccountParam} from "./AccountParam";
import {ChargeParam} from "./ChargeParam";
import {AccountBasicParam} from "./AccountBasicParam";
import {CardParam} from "./CardParam";
import {RecurringChargeParam} from "./RecurringChargeParam";
import {BankAccountParam} from "./BankAccountParam";
import {OrderParam} from "./OrderParam";
import {PayNowIdConstants} from "./PayNowIdConstants";


export abstract class AbstractPayNowIdRequestDto extends MdkDtoBase {

    protected constructor(serviceType: string) {
        super();
        this._serviceType = serviceType;
    }

    private readonly _serviceType: string;


    payNowIdParam: PayNowIdParam;

    get accountId(): string {
        this.existAccountParam();
        return this.payNowIdParam.accountParam.accountId;
    }

    set accountId(value: string) {
        this.existAccountParam();
        this.payNowIdParam.accountParam.accountId = value;
    }

    get onetimeToken(): string {
        return this.payNowIdParam.accountParam.onetimeToken;
    }

    set onetimeToken(value: string) {
        this.existAccountParam();
        this.payNowIdParam.accountParam.onetimeToken = value;
    }

    get onetimeTokenType(): string {
        return this.payNowIdParam.accountParam.onetimeTokenType;
    }

    set onetimeTokenType(value: string) {
        this.existAccountParam();
        this.payNowIdParam.accountParam.onetimeTokenType = value;
    }

    get originalAccountId(): string {
        return this.payNowIdParam.accountParam.originalAccountId;
    }

    set originalAccountId(value: string) {
        this.existAccountParam();
        this.payNowIdParam.accountParam.originalAccountId = value;
    }

    get payNowId(): string {
        this.existAccountParam();
        return this.payNowIdParam.accountParam.payNowId;
    }

    set payNowId(value: string) {
        this.existAccountParam();
        this.payNowIdParam.accountParam.payNowId = value;
    }

    get transData(): string {
        this.existAccountParam();
        return this.payNowIdParam.accountParam.transData;
    }

    set transData(value: string) {
        this.existAccountParam();
        this.payNowIdParam.accountParam.transData = value;
    }

    get createDate(): string {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.createDate;
    }

    set createDate(value: string) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.createDate = value;
    }

    get deleteDate(): string {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.deleteDate;
    }

    set deleteDate(value: string) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.deleteDate = value;
    }

    get forceDeleteDate(): string {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.forceDeleteDate;
    }

    set forceDeleteDate(value: string) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.forceDeleteDate = value;
    }

    get deleteCardInfo(): string {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.deleteCardInfo;
    }

    set deleteCardInfo(value: string) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.deleteCardInfo = value;
    }

    get addCardInfo(): string {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.addCardInfo;
    }

    set addCardInfo(value: string) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.addCardInfo = value;
    }

    get deleteOriginalAccountId(): string {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.deleteOriginalAccountId;
    }

    set deleteOriginalAccountId(value: string) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.deleteOriginalAccountId = value;
    }

    get defaultCardOnly(): string {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.defaultCardOnly;
    }

    set defaultCardOnly(value: string) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.defaultCardOnly = value;
    }

    get cleaningConfig(): string {
        this.existAccountBasicParam();
        return this.payNowIdParam.accountParam.accountBasicParam.cleaningConfig;
    }

    set cleaningConfig(value: string) {
        this.existAccountBasicParam();
        this.payNowIdParam.accountParam.accountBasicParam.cleaningConfig = value;
    }

    get cardId(): string {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.cardId;
    }

    set cardId(value: string) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.cardId = value;
    }

    get defaultCard(): string {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.defaultCard;
    }

    set defaultCard(value: string) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.defaultCard = value;
    }

    get defaultCardId(): string {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.defaultCardId;
    }

    set defaultCardId(value: string) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.defaultCardId = value;
    }

    get updater(): string {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.updater;
    }

    set updater(value: string) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.updater = value;
    }

    get cardNumber(): string {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.cardNumber;
    }

    set cardNumber(value: string) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.cardNumber = value;
    }

    get cardExpire(): string {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.cardExpire;
    }

    set cardExpire(value: string) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.cardExpire = value;
    }

    get cardholderName(): string {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.cardholderName;
    }

    set cardholderName(value: string) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.cardholderName = value;
    }

    get token(): string {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.token;
    }

    set token(value: string) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.token = value;
    }

    get cardNumberMaskType(): string {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.cardNumberMaskType;
    }

    set cardNumberMaskType(value: string) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.cardNumberMaskType = value;
    }

    get withAuthorize(): string {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.withAuthorize;
    }

    set withAuthorize(value: string) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.withAuthorize = value;
    }

    get securityCode(): string {
        this.existCardParam();
        return this.payNowIdParam.accountParam.cardParam.securityCode;
    }

    set securityCode(value: string) {
        this.existCardParam();
        this.payNowIdParam.accountParam.cardParam.securityCode = value;
    }

    get groupId(): string {
        let groupId = null;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            this.existRecurringChargeParam();
            groupId = this.payNowIdParam.accountParam.recurringChargeParam.groupId
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            this.existChargeParam();
            groupId = this.payNowIdParam.chargeParam.groupId;
        }
        return groupId
    }

    set groupId(value: string) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam();
            this.payNowIdParam.accountParam.recurringChargeParam.groupId = value;
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam();
            this.payNowIdParam.chargeParam.groupId = value;
        }
    }

    get startDate(): string {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.startDate;
    }

    set startDate(value: string) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.startDate = value;
    }

    get endDate(): string {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.endDate;
    }

    set endDate(value: string) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.endDate = value;
    }


    get finalCharge(): string {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.finalCharge;
    }

    set finalCharge(value: string) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.finalCharge = value;
    }

    get recurringMemo1(): string {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.recurringMemo1;
    }

    set recurringMemo1(value: string) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.recurringMemo1 = value;
    }

    get recurringMemo2(): string {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.recurringMemo2;
    }

    set recurringMemo2(value: string) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.recurringMemo2 = value;
    }

    get recurringMemo3(): string {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.recurringMemo3;
    }

    set recurringMemo3(value: string) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.recurringMemo3 = value;
    }

    get useChargeOption(): string {
        this.existRecurringChargeParam();
        return this.payNowIdParam.accountParam.recurringChargeParam.useChargeOption;
    }

    set useChargeOption(value: string) {
        this.existRecurringChargeParam();
        this.payNowIdParam.accountParam.recurringChargeParam.useChargeOption = value;
    }

    get salesDay(): string {
        let salesDay = null;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            this.existRecurringChargeParam();
            salesDay = this.payNowIdParam.accountParam.recurringChargeParam.salesDay
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            this.existChargeParam();
            salesDay = this.payNowIdParam.chargeParam.salesDay;
        }
        return salesDay;
    }

    set salesDay(value: string) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam();
            this.payNowIdParam.accountParam.recurringChargeParam.salesDay = value;
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam();
            this.payNowIdParam.chargeParam.salesDay = value;
        }
    }

    get acquireCode(): string {
        let acquireCode = null;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            this.existRecurringChargeParam();
            acquireCode = this.payNowIdParam.accountParam.recurringChargeParam.acquireCode
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            this.existChargeParam();
            acquireCode = this.payNowIdParam.chargeParam.acquireCode;
        }
        return acquireCode;
    }

    set acquireCode(value: string) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam();
            this.payNowIdParam.accountParam.recurringChargeParam.acquireCode = value;
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam();
            this.payNowIdParam.chargeParam.acquireCode = value;
        }
    }

    get oneTimeAmount(): string {
        let oneTimeAmount = null;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            this.existRecurringChargeParam();
            oneTimeAmount = this.payNowIdParam.accountParam.recurringChargeParam.oneTimeAmount
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            this.existChargeParam();
            oneTimeAmount = this.payNowIdParam.chargeParam.oneTimeAmount;
        }
        return oneTimeAmount;
    }

    set oneTimeAmount(value: string) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam();
            this.payNowIdParam.accountParam.recurringChargeParam.oneTimeAmount = value;
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam();
            this.payNowIdParam.chargeParam.oneTimeAmount = value;
        }
    }

    get amount(): string {
        let amount = null;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            this.existRecurringChargeParam();
            amount = this.payNowIdParam.accountParam.recurringChargeParam.amount
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            this.existChargeParam();
            amount = this.payNowIdParam.chargeParam.amount;
        }
        return amount;
    }

    set amount(value: string) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam();
            this.payNowIdParam.accountParam.recurringChargeParam.amount = value;
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam();
            this.payNowIdParam.chargeParam.amount = value;
        }
    }

    get bankCode(): string {
        this.existBankAccountParam();
        return this.payNowIdParam.accountParam.bankAccountParam.bankCode;
    }

    set bankCode(value: string) {
        this.existBankAccountParam();
        this.payNowIdParam.accountParam.bankAccountParam.bankCode = value;
    }

    get branchCode(): string {
        this.existBankAccountParam();
        return this.payNowIdParam.accountParam.bankAccountParam.branchCode;
    }

    set branchCode(value: string) {
        this.existBankAccountParam();
        this.payNowIdParam.accountParam.bankAccountParam.branchCode = value;
    }

    get accountType(): string {
        this.existBankAccountParam();
        return this.payNowIdParam.accountParam.bankAccountParam.accountType;
    }

    set accountType(value: string) {
        this.existBankAccountParam();
        this.payNowIdParam.accountParam.bankAccountParam.accountType = value;
    }

    get accountNumber(): string {
        this.existBankAccountParam();
        return this.payNowIdParam.accountParam.bankAccountParam.accountNumber;
    }

    set accountNumber(value: string) {
        this.existBankAccountParam();
        this.payNowIdParam.accountParam.bankAccountParam.accountNumber = value;
    }

    get accountManageType(): string {
        this.existBankAccountParam();
        return this.payNowIdParam.accountParam.bankAccountParam.accountManageType;
    }

    set accountManageType(value: string) {
        this.existBankAccountParam();
        this.payNowIdParam.accountParam.bankAccountParam.accountManageType = value;
    }

    get rejectBankAccount(): string {
        this.existBankAccountParam();
        return this.payNowIdParam.accountParam.bankAccountParam.rejectBankAccount;
    }

    set rejectBankAccount(value: string) {
        this.existBankAccountParam();
        this.payNowIdParam.accountParam.bankAccountParam.rejectBankAccount = value;
    }

    get groupName(): string {
        this.existChargeParam();
        return this.payNowIdParam.chargeParam.groupName;
    }

    set groupName(value: string) {
        this.existChargeParam();
        this.payNowIdParam.chargeParam.groupName = value;
    }

    get type(): string {
        this.existChargeParam();
        return this.payNowIdParam.chargeParam.type;
    }

    set type(value: string) {
        this.existChargeParam();
        this.payNowIdParam.chargeParam.type = value;
    }

    get chargeType(): string {
        this.existChargeParam();
        return this.payNowIdParam.chargeParam.chargeType;
    }

    set chargeType(value: string) {
        this.existChargeParam();
        this.payNowIdParam.chargeParam.chargeType = value;
    }

    get schedule(): string {
        this.existChargeParam();
        return this.payNowIdParam.chargeParam.schedule;
    }

    set schedule(value: string) {
        this.existChargeParam();
        this.payNowIdParam.chargeParam.schedule = value;
    }

    get tanking(): string {
        this.existPayNowIdParam();
        return this.payNowIdParam.tanking;
    }

    set tanking(value: string) {
        this.existPayNowIdParam();
        this.payNowIdParam.tanking = value;
    }

    get originalOrderId(): string {
        this.existOrderParam();
        return this.payNowIdParam.orderParam.originalOrderId;
    }

    set originalOrderId(value: string) {
        this.existOrderParam();
        this.payNowIdParam.orderParam.originalOrderId = value;
    }

    get cleaningMerchantId(): string {
        this.existOrderParam();
        return this.payNowIdParam.orderParam.cleaningMerchantId;
    }

    set cleaningMerchantId(value: string) {
        this.existOrderParam();
        this.payNowIdParam.orderParam.cleaningMerchantId = value;
    }

    private isRecurring(): boolean {
        return (PayNowIdConstants.SERVICE_TYPE_ACCOUNT == this._serviceType ||
            PayNowIdConstants.SERVICE_TYPE_RECURRING == this._serviceType);
    }

    private isCharge(): boolean {
        return (PayNowIdConstants.SERVICE_TYPE_CHARGE == this._serviceType)
    }

    protected existPayNowIdParam() {
        if (this.payNowIdParam == null) {
            this.payNowIdParam = new PayNowIdParam();
        }
    }

    protected existAccountParam() {
        this.existPayNowIdParam();
        if (this.payNowIdParam.accountParam == null) {
            this.payNowIdParam.accountParam = new AccountParam();
        }
    }

    protected existAccountBasicParam() {
        this.existAccountParam();
        if (this.payNowIdParam.accountParam.accountBasicParam == null) {
            this.payNowIdParam.accountParam.accountBasicParam = new AccountBasicParam();
        }
    }

    protected existCardParam() {
        this.existAccountParam();
        if (this.payNowIdParam.accountParam.cardParam == null) {
            this.payNowIdParam.accountParam.cardParam = new CardParam();
        }
    }

    protected existRecurringChargeParam() {
        this.existAccountParam();
        if (this.payNowIdParam.accountParam.recurringChargeParam == null) {
            this.payNowIdParam.accountParam.recurringChargeParam = new RecurringChargeParam();
        }
    }

    protected existChargeParam() {
        this.existPayNowIdParam();
        if (this.payNowIdParam.chargeParam == null) {
            this.payNowIdParam.chargeParam = new ChargeParam();
        }
    }

    protected existBankAccountParam() {
        this.existAccountParam();
        if (this.payNowIdParam.accountParam.bankAccountParam == null) {
            this.payNowIdParam.accountParam.bankAccountParam = new BankAccountParam();
        }
    }

    protected existOrderParam() {
        this.existPayNowIdParam();
        if (this.payNowIdParam.orderParam == null) {
            this.payNowIdParam.orderParam = new OrderParam();
        }
    }


}
