import {describe} from "mocha"
import assert = require('power-assert');
import {MerchantUtility} from "../src/tgMdk/MerchantUtility";

describe('MerchantUtility Test', () => {

    const secretKey = "abcdef0123456789abcdef0123456789abcdef0123456789abcdef0123456789";

    it("checkMessage", () => {

        const contentHmacHeader = "h=HmacSHA256;s=A100000000000001000000cc;v=96afe3ca78dd828e1b4643dacae031422ca252bdb2a109178d4637bd44a7ee99";
        const messageBody = "numberOfNotify=1&pushTime=20230609163134&pushId=100&orderId0000=1657593096&vResultCode0000=G011A00100000000&txnType0000=AuthorizeConfirm&mpiMstatus0000=success&cardMstatus0000=success&dummy0000=1";
        const result = MerchantUtility.checkMessage(secretKey, messageBody, contentHmacHeader);

        assert.equal(result, true);
    });


});
