import {MerchantConfig} from "./MerchantConfig";
import {IHttpClient} from "./IHttpClient";
import fetch, {Response} from "node-fetch";

export class HttpClient implements IHttpClient {

    private _config: MerchantConfig;

    constructor(config: MerchantConfig) {
        this._config = config;
    }

    async execute(uri: string, json: string): Promise<Response> {

        const headers = {
            'Content-Type': 'application/x-www-form-urlencoded',
            'User-Agent': MerchantConfig.userAgent
        };

        let options = {
            method: 'post',
            headers: headers,
            body: encodeURIComponent(json),
            timeout: this._config.timeout * 1000,
        };

        const res = await fetch(uri, options);
        return res.ok ? res : Promise.reject(res);
    }

}
