import {AbstractPaymentCreditRequestDto} from "./AbstractPaymentCreditRequestDto";
import {OptionParam} from "../OptionParam";
import {IRequestDto} from "../../tgMdk/IRequestDto";
import {FraudDetectionV2RequestDto} from "../FraudDetectionV2/FraudDetectionV2RequestDto";
import {FraudDetectionV2ParametersDto} from "../FraudDetectionV2/FraudDetectionV2ParametersDto";
import {FraudDetectionV2RiskDto} from "../FraudDetectionV2/FraudDetectionV2RiskDto";


export class CardNoAuthorizeFraudDetectionRequestDto extends AbstractPaymentCreditRequestDto implements IRequestDto {
    readonly serviceType: string = "card";
    readonly serviceCommand: string = "Authorize";

    private _maskedLog: string;

    constructor() {
        super();

        this.cardNumber = "4111111111111111";
        this.cardExpire = "12/50";
        this.fraudDetectionV2Request = new FraudDetectionV2RequestDto();
        this.fraudDetectionV2Request.fraudDetectionOnly = "true";
        this.fraudDetectionV2Request.risk = new FraudDetectionV2RiskDto();
        this.fraudDetectionV2Request.risk.parameters = new FraudDetectionV2ParametersDto();
        this.fraudDetectionV2Request.risk.parameters.custVerification = "true";
    }


    orderId: string;


    amount: string;


    cardNumber: string;


    cardExpire: string;


    fraudDetectionV2Request: FraudDetectionV2RequestDto;


    optionParams: OptionParam[];

    get maskedLog(): string {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }

}
