import type { IRequestDto } from "./IRequestDto.js";
import { MerchantConfig } from "./MerchantConfig.js";
import type { Logger } from "log4js";
import type { IResponseDto } from "./IResponseDto.js";
import type { IHttpClient } from "./IHttpClient.js";
export declare class Transaction {
    private readonly _logger;
    private readonly _config;
    private _httpClient;
    constructor(logger: Logger, config: MerchantConfig, httpClient?: IHttpClient);
    execute<T extends IResponseDto>(requestDto: IRequestDto, type: {
        new (): T;
    }): Promise<T>;
    private sendRequest;
    static createSendUrl(requestDto: IRequestDto, host: string, addUrlPayment: string, addUrlPaymentVersion: string, payNowIdServiceType: Array<string>, addUrlVtId: string, addUrlVtIdVersion: string, serviceCommandSearch: string, searchServer: string, dummyRequest: string, dummyServer: string): string;
    static appendConnectParam(requestDto: IRequestDto, merchantCcId: string | undefined, merchantSecretKey: string | undefined, dummyRequest: string, logger: Logger): string;
    static getErrorResponse<T extends IResponseDto>(vResultCode: string, errorMessage: string, type: {
        new (): T;
    }): T;
}
