import type {IRequestDto} from "../../tgMdk/IRequestDto.js";
import {AbstractPaymentRequestDto} from "../AbstractPaymentRequestDto.js";


export class AmazonpayAuthorizeRequestDto extends AbstractPaymentRequestDto implements IRequestDto {
    readonly serviceType: string = "amazonpay";
    readonly serviceCommand: string = "Authorize";

    orderId: string | undefined;


    accountingType: string | undefined;


    consentAuthType: string | undefined;


    amount: string | undefined;


    withCapture: string | undefined;


    suppressShippingAddressView: string | undefined;


    noteToBuyer: string | undefined;


    successUrl: string | undefined;


    cancelUrl: string | undefined;


    errorUrl: string | undefined;


    authorizePushUrl: string | undefined;


    capturePushUrl: string | undefined;


    cancelPushUrl: string | undefined;


    frequencyUnit: string | undefined;


    frequencyValue: string | undefined;


    addressRestrictions: string | undefined;


    payConfirmScreenType: string | undefined;


    payConfirmScreenUrl: string | undefined;


    extendExpiration: string | undefined;


    private _maskedLog: string | undefined;

    get maskedLog(): string | undefined {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }
}

