import type {IRequestDto} from "../../tgMdk/IRequestDto.js";
import {AbstractPaymentRequestDto} from "../AbstractPaymentRequestDto.js";


export class AmazonpayReAuthorizeRequestDto extends AbstractPaymentRequestDto implements IRequestDto {
    readonly serviceType: string = "amazonpay";
    readonly serviceCommand: string = "ReAuthorize";


    orderId: string | undefined;


    originalOrderId: string | undefined;


    amount: string | undefined;


    withCapture: string | undefined;


    noteToBuyer: string | undefined;


    authorizePushUrl: string | undefined;


    capturePushUrl: string | undefined;


    cancelPushUrl: string | undefined;


    private _maskedLog: string | undefined;

    get maskedLog(): string | undefined {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }
}

