import {AbstractPaymentCreditRequestDto} from "./AbstractPaymentCreditRequestDto.js";
import {OptionParam} from "../OptionParam.js";
import type {IRequestDto} from "../../tgMdk/IRequestDto.js";
import {FraudDetectionV2RequestDto} from "../FraudDetectionV2/FraudDetectionV2RequestDto.js";
import {FraudDetectionV2ParametersDto} from "../FraudDetectionV2/FraudDetectionV2ParametersDto.js";
import {FraudDetectionV2RiskDto} from "../FraudDetectionV2/FraudDetectionV2RiskDto.js";


export class CardNoAuthorizeFraudDetectionRequestDto extends AbstractPaymentCreditRequestDto implements IRequestDto {
    readonly serviceType: string = "card";
    readonly serviceCommand: string = "Authorize";

    private _maskedLog: string | undefined;

    constructor() {
        super();

        this.cardNumber = "4111111111111111";
        this.cardExpire = "12/50";
        this.fraudDetectionV2Request = new FraudDetectionV2RequestDto();
        this.fraudDetectionV2Request.fraudDetectionOnly = "true";
        this.fraudDetectionV2Request.risk = new FraudDetectionV2RiskDto();
        this.fraudDetectionV2Request.risk.parameters = new FraudDetectionV2ParametersDto();
        this.fraudDetectionV2Request.risk.parameters.custVerification = "true";
    }


    orderId: string | undefined;


    amount: string | undefined;


    cardNumber: string | undefined;


    cardExpire: string | undefined;


    fraudDetectionV2Request: FraudDetectionV2RequestDto;


    optionParams: OptionParam[] | undefined;

    get maskedLog(): string | undefined {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }

}
