import type {IRequestDto} from "../../tgMdk/IRequestDto.js";
import {AbstractPaymentRequestDto} from "../AbstractPaymentRequestDto.js";
import {PaypayProductDto} from "./PaypayProductDto.js";


export class PaypayAuthorizeRequestDto extends AbstractPaymentRequestDto implements IRequestDto {
    readonly serviceType: string = "paypay";
    readonly serviceCommand: string = "Authorize";


    orderId: string | undefined;


    serviceOptionType: string | undefined;


    accountingType: string | undefined;


    oneTimeCode: string | undefined;


    amount: string | undefined;


    withCapture: string | undefined;


    storeId: string | undefined;


    terminalId: string | undefined;


    receiptNumber: string | undefined;


    settleBizCode: string | undefined;


    itemName: string | undefined;


    itemId: string | undefined;


    successUrl: string | undefined;


    cancelUrl: string | undefined;


    errorUrl: string | undefined;


    pushUrl: string | undefined;


    orderDescription: string | undefined;


    storeInfo: string | undefined;


    userAgent: string | undefined;


    isTransitionResultUrl: string | undefined;


    provider: string | undefined;


    transitionType: string | undefined;


    extendParameterType: string | undefined;


    onlinePaymentType: string | undefined;


    payTimeoutDatetime: string | undefined;


    products: PaypayProductDto[] | undefined;


    voucherAmount: string | undefined;


    private _maskedLog: string | undefined;

    get maskedLog(): string | undefined {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }
}

