import type {IRequestDto} from "../../tgMdk/IRequestDto.js";
import {AbstractPaymentRequestDto} from "../AbstractPaymentRequestDto.js";
import type {PaypayProductDto} from "./PaypayProductDto.js";


export class PaypayRefundRequestDto extends AbstractPaymentRequestDto implements IRequestDto {
    readonly serviceType: string = "paypay";
    readonly serviceCommand: string = "Refund";


    orderId: string | undefined;


    serviceOptionType: string | undefined;


    storeId: string | undefined;


    terminalId: string | undefined;


    receiptNumber: string | undefined;


    settleBizCode: string | undefined;


    amount: string | undefined;


    reason: string | undefined;


    products: PaypayProductDto[] | undefined;


    private _maskedLog: string | undefined;

    get maskedLog(): string | undefined {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }

}

