import type {IRequestDto} from "../../tgMdk/IRequestDto.js";
import {AbstractPaymentRequestDto} from "../AbstractPaymentRequestDto.js";


export class RakutenAuthorizeRequestDto extends AbstractPaymentRequestDto implements IRequestDto {
    readonly serviceType: string = "rakuten";
    readonly serviceCommand: string = "Authorize";

    orderId: string | undefined;

    payType: string | undefined;

    accountingType: string | undefined;

    amount: string | undefined;

    withCapture: string | undefined;

    itemId: string | undefined;

    itemName: string | undefined;

    successUrl: string | undefined;

    errorUrl: string | undefined;

    pushUrl: string | undefined;

    private _maskedLog: string | undefined;

    get maskedLog(): string | undefined {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }
}

