import {MdkLocalException} from "../src/tgMdk/MdkLocalException.js";
import {describe, it, assert} from "vitest";
import * as Log4js from "log4js";

describe('MdkLocalException Test', () => {

    Log4js.configure(
        {
            appenders: {system: {type: 'stdout', layout: {type: 'pattern', pattern: '%d %[%5p%] %c %z %m'}}},
            categories: {default: {appenders: ['system'], level: 'info'}}
        }
    );
    const logger = Log4js.getLogger("default");

    it("Test MdkLocalException messages", () => {

        const ma01 = new MdkLocalException(logger, "MA01");
        assert.equal(ma01.errorMessage, "{0} is missing in the Config file");

        const ma01_2 = new MdkLocalException(logger, "MA01", ["host"]);
        assert.equal(ma01_2.errorMessage, "host is missing in the Config file");

        const ma02 = new MdkLocalException(logger, "MA02");
        assert.equal(ma02.errorMessage, "{0} value \"{1}\" in the Config file is not correct");

        const ma02_2 = new MdkLocalException(logger, "MA02", ["foo", "val"]);
        assert.equal(ma02_2.errorMessage, "foo value \"val\" in the Config file is not correct");

        const ma03 = new MdkLocalException(logger, "MA03");
        assert.equal(ma03.errorMessage, "{0} file does not exist");

        const ma04 = new MdkLocalException(logger, "MA04");
        assert.equal(ma04.errorMessage, "Message body encryption error");

        const ma06 = new MdkLocalException(logger, "MA06");
        assert.equal(ma06.errorMessage, "Message body decryption error");

        const ma99 = new MdkLocalException(logger, "MA99");
        assert.equal(ma99.errorMessage, "System internal error");

        const mb01 = new MdkLocalException(logger, "MB01");
        assert.equal(mb01.errorMessage, "Could not find the Config file. {0}");

        const mb02 = new MdkLocalException(logger, "MB02");
        assert.equal(mb02.errorMessage, "Could not read the Config file");

        const mb03 = new MdkLocalException(logger, "MB03");
        assert.equal(mb03.errorMessage, "SslStream creation error has occurred.");

        const mb99 = new MdkLocalException(logger, "MB99");
        assert.equal(mb99.errorMessage, "System internal error");

        const mf01 = new MdkLocalException(logger, "MF01");
        assert.equal(mf01.errorMessage, "Could not connect to the Proxy Server. ErrorInfo:[{0}]");

        const mf02 = new MdkLocalException(logger, "MF02");
        assert.equal(mf02.errorMessage, "Could not connect to the GW Server");

        const mf03 = new MdkLocalException(logger, "MF03");
        assert.equal(mf03.errorMessage, "Connection to server timed out");

        const mf05 = new MdkLocalException(logger, "MF05");
        assert.equal(mf05.errorMessage, "500 Internal Server Error");

        const mf06 = new MdkLocalException(logger, "MF06");
        assert.equal(mf06.errorMessage, "502 Bad Gateway");

        const mf07 = new MdkLocalException(logger, "MF07");
        assert.equal(mf07.errorMessage, "503 Service Unavailable");

        const mf99 = new MdkLocalException(logger, "MF99");
        assert.equal(mf99.errorMessage, "System internal error");

    });



});
