import { AbstractPaymentCreditRequestDto } from "./AbstractPaymentCreditRequestDto.js";
import { OptionParam } from "../OptionParam.js";
import { FraudDetectionV2RequestDto } from "../FraudDetectionV2/FraudDetectionV2RequestDto.js";
import { FraudDetectionV2ParametersDto } from "../FraudDetectionV2/FraudDetectionV2ParametersDto.js";
import { FraudDetectionV2RiskDto } from "../FraudDetectionV2/FraudDetectionV2RiskDto.js";
export class CardNoAuthorizeFraudDetectionRequestDto extends AbstractPaymentCreditRequestDto {
    serviceType = "card";
    serviceCommand = "Authorize";
    _maskedLog;
    constructor() {
        super();
        this.cardNumber = "4111111111111111";
        this.cardExpire = "12/50";
        this.fraudDetectionV2Request = new FraudDetectionV2RequestDto();
        this.fraudDetectionV2Request.fraudDetectionOnly = "true";
        this.fraudDetectionV2Request.risk = new FraudDetectionV2RiskDto();
        this.fraudDetectionV2Request.risk.parameters = new FraudDetectionV2ParametersDto();
        this.fraudDetectionV2Request.risk.parameters.custVerification = "true";
    }
    orderId;
    amount;
    cardNumber;
    cardExpire;
    fraudDetectionV2Request;
    optionParams;
    get maskedLog() {
        return this._maskedLog;
    }
    set maskedLog(value) {
        this._maskedLog = value;
    }
}
//# sourceMappingURL=CardNoAuthorizeFraudDetectionRequestDto.js.map