import {MerchantConfig} from "./MerchantConfig.js";
import type {IHttpClient} from "./IHttpClient.js";
import fetch, {Response} from "node-fetch";

export class HttpClient implements IHttpClient {

    private _config: MerchantConfig;

    constructor(config: MerchantConfig) {
        this._config = config;
    }

    async execute(uri: string, json: string): Promise<Response> {

        const headers = {
            'Content-Type': 'application/x-www-form-urlencoded',
            'User-Agent': MerchantConfig.userAgent
        };

        const controller = new AbortController();
        setTimeout(() => {
            controller.abort()
        }, this._config.timeout * 1000);

        const options = {
            method: 'post',
            headers: headers,
            body: encodeURIComponent(json),
            signal: controller.signal
        };

        const res = await fetch(uri, options);
        return res.ok ? res : Promise.reject(res);
    }

}
