import {MdkDtoBase} from "./MdkDtoBase.js";
import {PayNowIdParam} from "./PayNowId/PayNowIdParam.js";
import {AccountParam} from "./PayNowId/AccountParam.js";
import {AccountBasicParam} from "./PayNowId/AccountBasicParam.js";
import {CardParam} from "./PayNowId/CardParam.js";
import {RecurringChargeParam} from "./PayNowId/RecurringChargeParam.js";
import {BankAccountParam} from "./PayNowId/BankAccountParam.js";


export abstract class AbstractPaymentRequestDto extends MdkDtoBase {


    payNowIdParam: PayNowIdParam | undefined;

    get accountId(): string | undefined {
        this.existAccountParam();
        return this.payNowIdParam?.accountParam?.accountId;
    }

    set accountId(value: string) {
        this.existAccountParam().accountId = value;
    }

    get createDate(): string | undefined {
        this.existAccountBasicParam();
        return this.payNowIdParam?.accountParam?.accountBasicParam?.createDate;
    }

    set createDate(value: string) {
        this.existAccountBasicParam().createDate = value;
    }

    get freeKey(): string | undefined {
        return this?.payNowIdParam?.freeKey;
    }

    set freeKey(value: string) {
        this.existPayNowIdParam().freeKey = value;
    }

    get memo1(): string | undefined {
        this.existPayNowIdParam();
        return this.payNowIdParam?.memo1;
    }

    set memo1(value: string) {
        this.existPayNowIdParam().memo1 = value;
    }

    get receiptData(): string | undefined {
        return this.payNowIdParam?.receiptData;
    }

    set receiptData(value: string) {
        this.existPayNowIdParam().receiptData = value;
    }

    protected existPayNowIdParam(): PayNowIdParam {
        if (this.payNowIdParam == null) {
            this.payNowIdParam = new PayNowIdParam();
        }
        return this.payNowIdParam;
    }

    protected existAccountParam(): AccountParam {
        const payNowIdParam = this.existPayNowIdParam();
        if (payNowIdParam.accountParam == null) {
            payNowIdParam.accountParam = new AccountParam();
        }
        return payNowIdParam.accountParam;
    }

    protected existAccountBasicParam(): AccountBasicParam {
        const accountParam = this.existAccountParam();
        if (accountParam.accountBasicParam == null) {
            accountParam.accountBasicParam = new AccountBasicParam();
        }
        return accountParam.accountBasicParam;
    }

    protected existCardParam() {
        const accountParam = this.existAccountParam();
        if (accountParam.cardParam == null) {
            accountParam.cardParam = new CardParam();
        }
        return accountParam.cardParam;
    }

    protected existRecurringChargeParam(): RecurringChargeParam {
        const accountParam = this.existAccountParam();
        if (accountParam.recurringChargeParam == null) {
            accountParam.recurringChargeParam = new RecurringChargeParam();
        }
        return accountParam.recurringChargeParam;
    }

    protected existBankAccountParam(): BankAccountParam {
        const accountParam = this.existAccountParam();
        if (accountParam.bankAccountParam == null) {
            accountParam.bankAccountParam = new BankAccountParam();
        }
        return accountParam.bankAccountParam;
    }

}
