import {AbstractPaymentRequestDto} from "../AbstractPaymentRequestDto.js";


export abstract class AbstractPaymentCreditRequestDto extends AbstractPaymentRequestDto {

    get cardId(): string | undefined {
        return this.payNowIdParam?.accountParam?.cardParam?.cardId;
    }

    set cardId(value: string) {
        this.existCardParam().cardId = value;
    }

    get defaultCard(): string | undefined {
        return this.payNowIdParam?.accountParam?.cardParam?.defaultCard;
    }

    set defaultCard(value: string) {
        this.existCardParam().defaultCard = value;
    }

    get groupId(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.groupId;
    }

    set groupId(value: string) {
        this.existRecurringChargeParam().groupId = value;
    }

    get startDate(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.startDate;
    }

    set startDate(value: string) {
        this.existRecurringChargeParam().startDate = value;
    }

    get endDate(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.endDate;
    }

    set endDate(value: string) {
        this.existRecurringChargeParam().endDate = value;
    }

    get oneTimeAmount(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.oneTimeAmount;
    }

    set oneTimeAmount(value: string) {
        this.existRecurringChargeParam().oneTimeAmount = value;
    }

    get recurringAmount(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.amount;
    }

    set recurringAmount(value: string) {
        this.existRecurringChargeParam().amount = value;
    }

    get recurringMemo1(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.recurringMemo1;
    }

    set recurringMemo1(value: string) {
        this.existRecurringChargeParam().recurringMemo1 = value;
    }

    get recurringMemo2(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.recurringMemo2;
    }

    set recurringMemo2(value: string) {
        this.existRecurringChargeParam().recurringMemo2 = value;
    }

    get recurringMemo3(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.recurringMemo3;
    }

    set recurringMemo3(value: string) {
        this.existRecurringChargeParam().recurringMemo3 = value;
    }

    get useChargeOption(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.useChargeOption;
    }

    set useChargeOption(value: string) {
        this.existRecurringChargeParam().useChargeOption = value;
    }

    get recurringSalesDay(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.salesDay;
    }

    set recurringSalesDay(value: string) {
        this.existRecurringChargeParam().salesDay = value;
    }

    get recurringAcquireCode(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.acquireCode;
    }

    set recurringAcquireCode(value: string) {
        this.existRecurringChargeParam().acquireCode = value;
    }

    get tanking(): string | undefined {
        return this.payNowIdParam?.tanking;
    }

    set tanking(value: string) {
        this.existPayNowIdParam().tanking = value;
    }

    get updater(): string | undefined {
        return this.payNowIdParam?.accountParam?.cardParam?.updater;
    }

    set updater(value: string) {
        this.existCardParam().updater = value;
    }

    get token(): string | undefined {
        return this.payNowIdParam?.token;
    }

    set token(value: string) {
        this.existPayNowIdParam().token = value;
    }

}
