import {AbstractPaymentCreditRequestDto} from "./AbstractPaymentCreditRequestDto.js";
import {OptionParam} from "../OptionParam.js";
import type {IRequestDto} from "../../tgMdk/IRequestDto.js";


export class CardCancelRequestDto extends AbstractPaymentCreditRequestDto implements IRequestDto {
    readonly serviceType: string = "card";
    readonly serviceCommand: string = "Cancel";


    orderId: string | undefined;


    originalOrderId: string | undefined;


    amount: string | undefined;


    cardNumber: string | undefined;


    cardExpire: string | undefined;


    cardOptionType: string | undefined;


    cardCenter: string | undefined;


    acquirerCode: string | undefined;


    withNew: string | undefined;


    withDirect: string | undefined;


    cancelDay: string | undefined;


    itemCode: string | undefined;


    currencyUnit: string | undefined;


    salesDay: string | undefined;


    pin: string | undefined;


    paymentType: string | undefined;


    jis1SecondTrack: string | undefined;


    jis2Track: string | undefined;


    useOriginalOrder: string | undefined;


    jpo: string | undefined;


    firstPayment: string | undefined;


    bonusFirstPayment: string | undefined;


    withDirectOnFailure: string | undefined;


    mcAmount: string | undefined;


    posDataCode: string | undefined;


    terminalId: string | undefined;


    chipConditionCode: string | undefined;


    exSlipInfo: string | undefined;


    optionParams: OptionParam[] | undefined;

    private _maskedLog: string | undefined;

    get maskedLog(): string | undefined {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }

}
