import {AbstractPaymentCreditRequestDto} from "./AbstractPaymentCreditRequestDto.js";
import type {IRequestDto} from "../../tgMdk/IRequestDto.js";


export class CardCaptureRequestDto extends AbstractPaymentCreditRequestDto implements IRequestDto {
    readonly serviceType: string = "card";
    readonly serviceCommand: string = "Capture";


    orderId: string | undefined;


    originalOrderId: string | undefined;


    amount: string | undefined;


    cardNumber: string | undefined;


    cardExpire: string | undefined;


    cardOptionType: string | undefined;


    acquirerCode: string | undefined;


    salesDay: string | undefined;


    itemCode: string | undefined;


    withDirect: string | undefined;


    authCode: string | undefined;


    currencyUnit: string | undefined;


    jpo: string | undefined;


    firstPayment: string | undefined;


    bonusFirstPayment: string | undefined;


    mcAmount: string | undefined;


    terminalId: string | undefined;


    exSlipInfo: string | undefined;

    private _maskedLog: string | undefined;

    get maskedLog(): string | undefined {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }

}
