import {MdkDtoBase} from "../MdkDtoBase.js";
import {PayNowIdParam} from "./PayNowIdParam.js";
import {AccountParam} from "./AccountParam.js";
import {ChargeParam} from "./ChargeParam.js";
import {AccountBasicParam} from "./AccountBasicParam.js";
import {CardParam} from "./CardParam.js";
import {RecurringChargeParam} from "./RecurringChargeParam.js";
import {BankAccountParam} from "./BankAccountParam.js";
import {OrderParam} from "./OrderParam.js";
import {PayNowIdConstants} from "./PayNowIdConstants.js";


export abstract class AbstractPayNowIdRequestDto extends MdkDtoBase {

    protected constructor(serviceType: string) {
        super();
        this._serviceType = serviceType;
    }

    private readonly _serviceType: string;


    payNowIdParam: PayNowIdParam | undefined;

    get accountId(): string | undefined {
        return this.payNowIdParam?.accountParam?.accountId;
    }

    set accountId(value: string) {
        this.existAccountParam().accountId = value;
    }

    get onetimeToken(): string | undefined {
        return this.payNowIdParam?.accountParam?.onetimeToken;
    }

    set onetimeToken(value: string) {
        this.existAccountParam().onetimeToken = value;
    }

    get onetimeTokenType(): string | undefined {
        return this.payNowIdParam?.accountParam?.onetimeTokenType;
    }

    set onetimeTokenType(value: string) {
        this.existAccountParam().onetimeTokenType = value;
    }

    get originalAccountId(): string | undefined {
        return this.payNowIdParam?.accountParam?.originalAccountId;
    }

    set originalAccountId(value: string) {
        this.existAccountParam().originalAccountId = value;
    }

    get payNowId(): string | undefined {
        return this.payNowIdParam?.accountParam?.payNowId;
    }

    set payNowId(value: string) {
        this.existAccountParam().payNowId = value;
    }

    get transData(): string | undefined {
        return this.payNowIdParam?.accountParam?.transData;
    }

    set transData(value: string) {
        this.existAccountParam().transData = value;
    }

    get createDate(): string | undefined {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.createDate;
    }

    set createDate(value: string) {
        this.existAccountBasicParam().createDate = value;
    }

    get deleteDate(): string | undefined {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.deleteDate;
    }

    set deleteDate(value: string) {
        this.existAccountBasicParam().deleteDate = value;
    }

    get forceDeleteDate(): string | undefined {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.forceDeleteDate;
    }

    set forceDeleteDate(value: string) {
        this.existAccountBasicParam().forceDeleteDate = value;
    }

    get deleteCardInfo(): string | undefined {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.deleteCardInfo;
    }

    set deleteCardInfo(value: string) {
        this.existAccountBasicParam().deleteCardInfo = value;
    }

    get addCardInfo(): string | undefined {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.addCardInfo;
    }

    set addCardInfo(value: string) {
        this.existAccountBasicParam().addCardInfo = value;
    }

    get deleteOriginalAccountId(): string | undefined {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.deleteOriginalAccountId;
    }

    set deleteOriginalAccountId(value: string) {
        this.existAccountBasicParam().deleteOriginalAccountId = value;
    }

    get defaultCardOnly(): string | undefined {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.defaultCardOnly;
    }

    set defaultCardOnly(value: string) {
        this.existAccountBasicParam().defaultCardOnly = value;
    }

    get cleaningConfig(): string | undefined {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.cleaningConfig;
    }

    set cleaningConfig(value: string) {
        this.existAccountBasicParam().cleaningConfig = value;
    }

    get cardId(): string | undefined {
        return this?.payNowIdParam?.accountParam?.cardParam?.cardId;
    }

    set cardId(value: string) {
        this.existCardParam().cardId = value;
    }

    get defaultCard(): string | undefined {
        return this?.payNowIdParam?.accountParam?.cardParam?.defaultCard;
    }

    set defaultCard(value: string) {
        this.existCardParam().defaultCard = value;
    }

    get defaultCardId(): string | undefined {
        return this?.payNowIdParam?.accountParam?.cardParam?.defaultCardId;
    }

    set defaultCardId(value: string) {
        this.existCardParam().defaultCardId = value;
    }

    get updater(): string | undefined {
        return this?.payNowIdParam?.accountParam?.cardParam?.updater;
    }

    set updater(value: string) {
        this.existCardParam().updater = value;
    }

    get cardNumber(): string | undefined {
        return this?.payNowIdParam?.accountParam?.cardParam?.cardNumber;
    }

    set cardNumber(value: string) {
        this.existCardParam().cardNumber = value;
    }

    get cardExpire(): string | undefined {
        return this?.payNowIdParam?.accountParam?.cardParam?.cardExpire;
    }

    set cardExpire(value: string) {
        this.existCardParam().cardExpire = value;
    }

    get cardholderName(): string | undefined {
        return this?.payNowIdParam?.accountParam?.cardParam?.cardholderName;
    }

    set cardholderName(value: string) {
        this.existCardParam().cardholderName = value;
    }

    get token(): string | undefined {
        return this?.payNowIdParam?.accountParam?.cardParam?.token;
    }

    set token(value: string) {
        this.existCardParam().token = value;
    }

    get cardNumberMaskType(): string | undefined {
        return this.payNowIdParam?.accountParam?.cardParam?.cardNumberMaskType;
    }

    set cardNumberMaskType(value: string) {
        this.existCardParam().cardNumberMaskType = value;
    }

    get withAuthorize(): string | undefined {
        return this.payNowIdParam?.accountParam?.cardParam?.withAuthorize;
    }

    set withAuthorize(value: string) {
        this.existCardParam().withAuthorize = value;
    }

    get securityCode(): string | undefined {
        return this.payNowIdParam?.accountParam?.cardParam?.securityCode;
    }

    set securityCode(value: string) {
        this.existCardParam().securityCode = value;
    }

    get groupId(): string | undefined {
        let groupId = undefined;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            groupId = this.payNowIdParam?.accountParam?.recurringChargeParam?.groupId
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            groupId = this.payNowIdParam?.chargeParam?.groupId;
        }
        return groupId
    }

    set groupId(value: string) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam().groupId = value;
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam().groupId = value;
        }
    }

    get startDate(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.startDate;
    }

    set startDate(value: string) {
        this.existRecurringChargeParam().startDate = value;
    }

    get endDate(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.endDate;
    }

    set endDate(value: string) {
        this.existRecurringChargeParam().endDate = value;
    }


    get finalCharge(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.finalCharge;
    }

    set finalCharge(value: string) {
        this.existRecurringChargeParam().finalCharge = value;
    }

    get recurringMemo1(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.recurringMemo1;
    }

    set recurringMemo1(value: string) {
        this.existRecurringChargeParam().recurringMemo1 = value;
    }

    get recurringMemo2(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.recurringMemo2;
    }

    set recurringMemo2(value: string) {
        this.existRecurringChargeParam().recurringMemo2 = value;
    }

    get recurringMemo3(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.recurringMemo3;
    }

    set recurringMemo3(value: string) {
        this.existRecurringChargeParam().recurringMemo3 = value;
    }

    get useChargeOption(): string | undefined {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.useChargeOption;
    }

    set useChargeOption(value: string) {
        this.existRecurringChargeParam().useChargeOption = value;
    }

    get salesDay(): string | undefined {
        let salesDay = undefined;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            salesDay = this.payNowIdParam?.accountParam?.recurringChargeParam?.salesDay
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            salesDay = this.payNowIdParam?.chargeParam?.salesDay;
        }
        return salesDay;
    }

    set salesDay(value: string) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam().salesDay = value;
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam().salesDay = value;
        }
    }

    get acquireCode(): string | undefined {
        let acquireCode = undefined;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            acquireCode = this.payNowIdParam?.accountParam?.recurringChargeParam?.acquireCode
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            acquireCode = this.payNowIdParam?.chargeParam?.acquireCode;
        }
        return acquireCode;
    }

    set acquireCode(value: string) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam().acquireCode = value;
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam().acquireCode = value;
        }
    }

    get oneTimeAmount(): string | undefined {
        let oneTimeAmount = undefined;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            oneTimeAmount = this.payNowIdParam?.accountParam?.recurringChargeParam?.oneTimeAmount
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            oneTimeAmount = this.payNowIdParam?.chargeParam?.oneTimeAmount;
        }
        return oneTimeAmount;
    }

    set oneTimeAmount(value: string) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam().oneTimeAmount = value;
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam().oneTimeAmount = value;
        }
    }

    get amount(): string | undefined {
        let amount = undefined;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            amount = this.payNowIdParam?.accountParam?.recurringChargeParam?.amount
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            amount = this.payNowIdParam?.chargeParam?.amount;
        }
        return amount;
    }

    set amount(value: string) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam().amount = value;
        } else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam().amount = value;
        }
    }

    get bankCode(): string | undefined {
        return this.payNowIdParam?.accountParam?.bankAccountParam?.bankCode;
    }

    set bankCode(value: string) {
        this.existBankAccountParam().bankCode = value;
    }

    get branchCode(): string | undefined {
        return this.payNowIdParam?.accountParam?.bankAccountParam?.branchCode;
    }

    set branchCode(value: string) {
        this.existBankAccountParam().branchCode = value;
    }

    get accountType(): string | undefined {
        return this.payNowIdParam?.accountParam?.bankAccountParam?.accountType;
    }

    set accountType(value: string) {
        this.existBankAccountParam().accountType = value;
    }

    get accountNumber(): string | undefined {
        return this.payNowIdParam?.accountParam?.bankAccountParam?.accountNumber;
    }

    set accountNumber(value: string) {
        this.existBankAccountParam().accountNumber = value;
    }

    get accountManageType(): string | undefined {
        return this.payNowIdParam?.accountParam?.bankAccountParam?.accountManageType;
    }

    set accountManageType(value: string) {
        this.existBankAccountParam().accountManageType = value;
    }

    get rejectBankAccount(): string | undefined {
        return this.payNowIdParam?.accountParam?.bankAccountParam?.rejectBankAccount;
    }

    set rejectBankAccount(value: string) {
        this.existBankAccountParam().rejectBankAccount = value;
    }

    get groupName(): string | undefined {
        return this.payNowIdParam?.chargeParam?.groupName;
    }

    set groupName(value: string) {
        this.existChargeParam().groupName = value;
    }

    get type(): string | undefined {
        return this.payNowIdParam?.chargeParam?.type;
    }

    set type(value: string) {
        this.existChargeParam().type = value;
    }

    get chargeType(): string | undefined {
        return this.payNowIdParam?.chargeParam?.chargeType;
    }

    set chargeType(value: string) {
        this.existChargeParam().chargeType = value;
    }

    get schedule(): string | undefined {
        return this.payNowIdParam?.chargeParam?.schedule;
    }

    set schedule(value: string) {
        this.existChargeParam().schedule = value;
    }

    get tanking(): string | undefined {
        return this.payNowIdParam?.tanking;
    }

    set tanking(value: string) {
        this.existPayNowIdParam().tanking = value;
    }

    get originalOrderId(): string | undefined {
        return this.payNowIdParam?.orderParam?.originalOrderId;
    }

    set originalOrderId(value: string) {
        this.existOrderParam().originalOrderId = value;
    }

    get cleaningMerchantId(): string | undefined {
        return this.payNowIdParam?.orderParam?.cleaningMerchantId;
    }

    set cleaningMerchantId(value: string) {
        this.existOrderParam().cleaningMerchantId = value;
    }

    private isRecurring(): boolean {
        return (PayNowIdConstants.SERVICE_TYPE_ACCOUNT == this._serviceType ||
            PayNowIdConstants.SERVICE_TYPE_RECURRING == this._serviceType);
    }

    private isCharge(): boolean {
        return (PayNowIdConstants.SERVICE_TYPE_CHARGE == this._serviceType)
    }

    protected existPayNowIdParam(): PayNowIdParam {
        if (this.payNowIdParam == null) {
            this.payNowIdParam = new PayNowIdParam();
        }
        return this.payNowIdParam;
    }

    protected existAccountParam(): AccountParam {
        const payNowIdParam = this.existPayNowIdParam();
        if (payNowIdParam?.accountParam == null) {
            payNowIdParam.accountParam = new AccountParam();
        }
        return payNowIdParam.accountParam;
    }

    protected existAccountBasicParam(): AccountBasicParam {
        const accountParam = this.existAccountParam();
        if (accountParam.accountBasicParam == null) {
            accountParam.accountBasicParam = new AccountBasicParam();
        }
        return accountParam.accountBasicParam;
    }

    protected existCardParam(): CardParam {
        const accountParam = this.existAccountParam();
        if (accountParam.cardParam == null) {
            accountParam.cardParam = new CardParam();
        }
        return accountParam.cardParam;
    }

    protected existRecurringChargeParam(): RecurringChargeParam {
        const accountParam = this.existAccountParam();
        if (accountParam.recurringChargeParam == null) {
            accountParam.recurringChargeParam = new RecurringChargeParam();
        }
        return accountParam.recurringChargeParam;
    }

    protected existChargeParam(): ChargeParam {
        const payNowIdParam = this.existPayNowIdParam();
        if (payNowIdParam.chargeParam == null) {
            payNowIdParam.chargeParam = new ChargeParam();
        }
        return payNowIdParam.chargeParam;
    }

    protected existBankAccountParam(): BankAccountParam {
        const accountParam = this.existAccountParam();
        if (accountParam.bankAccountParam == null) {
            accountParam.bankAccountParam = new BankAccountParam();
        }
        return accountParam.bankAccountParam
    }

    protected existOrderParam(): OrderParam {
        const payNowIdParam = this.existPayNowIdParam();
        if (payNowIdParam.orderParam == null) {
            payNowIdParam.orderParam = new OrderParam();
        }
        return payNowIdParam.orderParam;
    }


}
