import {AbstractPayNowIdRequestDto} from "./AbstractPayNowIdRequestDto.js";
import type {IRequestDto} from "../../tgMdk/IRequestDto.js";


export class AccountRestoreRequestDto extends AbstractPayNowIdRequestDto implements IRequestDto {

    readonly serviceType: string = "account";
    readonly serviceCommand: string = "Restore";

    constructor() {
        super("account");
    }

    private _maskedLog: string | undefined;

    get maskedLog(): string | undefined {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }

}
