import {AbstractPayNowIdRequestDto} from "./AbstractPayNowIdRequestDto.js";
import type {IRequestDto} from "../../tgMdk/IRequestDto.js";


export class CardInfoUpdateRequestDto extends AbstractPayNowIdRequestDto implements IRequestDto {

    readonly serviceType: string = "cardinfo";
    readonly serviceCommand: string = "Update";

    constructor() {
        super("cardinfo");
    }

    private _maskedLog: string | undefined;

    get maskedLog(): string | undefined {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }

}
