import { MerchantConfig } from "./MerchantConfig.js";
import fetch, { Response } from "node-fetch";
export class HttpClient {
    _config;
    constructor(config) {
        this._config = config;
    }
    async execute(uri, json) {
        const headers = {
            'Content-Type': 'application/x-www-form-urlencoded',
            'User-Agent': MerchantConfig.userAgent
        };
        const controller = new AbortController();
        setTimeout(() => {
            controller.abort();
        }, this._config.timeout * 1000);
        const options = {
            method: 'post',
            headers: headers,
            body: encodeURIComponent(json),
            signal: controller.signal
        };
        const res = await fetch(uri, options);
        return res.ok ? res : Promise.reject(res);
    }
}
//# sourceMappingURL=HttpClient.js.map