import type {IRequestDto} from "./IRequestDto.js";
import {MerchantConfig} from "./MerchantConfig.js";
import type {IResponseDto} from "./IResponseDto.js";

export class MdkUtil {

    public static maskJson(obj: any) {
        if (Array.isArray(obj)) {
            this.parseArray(obj);
        } else if (typeof obj == "object") {
            this.parseObject(obj)
        }
    }

    private static parseObject(obj: any) {
        for (const key in obj) {
            if (obj.hasOwnProperty(key)) {
                if (Array.isArray(obj[key])) {
                    this.parseArray(obj[key]);
                } else if (typeof obj[key] == "object") {
                    this.parseObject(obj[key]);
                } else if (typeof obj[key] == "string") {
                    if (MerchantConfig.isNeedMask(key)) {
                        obj[key] = MdkUtil.getMaskedValue(key, obj[key])
                    }
                }
            }
        }
    }

    private static parseArray(obj: any) {
        for (const key in obj) {
            if (obj.hasOwnProperty(key)) {
                if (Array.isArray(obj[key])) {
                    this.parseArray(obj[key]);
                } else if (typeof obj[key] == "object") {
                    this.parseObject(obj[key]);
                } else {

                }
            }
        }
    }

    public static getMaskedValue(key: string, value: string) {
        if (value == null || value == "") {
            return "";
        }

        if (key.toLowerCase().indexOf("mailaddr") > -1) {
            const index = value.indexOf("@");
            if (index > 0) {
                return "*".repeat(index) + value.substring(index);
            } else {
                return value;
            }
        } else if (key.toLowerCase().indexOf("cardnumber") > -1) {
            const cardNumber = value.replace(/-/g, "");
            if (cardNumber.length >= 11) {
                return cardNumber.substring(0, 6) + ("*".repeat(cardNumber.length - 10)) + cardNumber.slice(-4);
            } else {
                return "*".repeat(cardNumber.length)
            }
        } else if (MerchantConfig.isNeedMask(key)) {
            return "*".repeat(value.length)
        } else {
            return value;
        }
    }

    public static convertDTOtoJsonObject(dto: IRequestDto) {
        if ((<any>dto).hasOwnProperty("serviceCommand")) delete (<any>dto)["serviceCommand"];
        if ((<any>dto).hasOwnProperty("serviceType")) delete (<any>dto)["serviceType"];
        if ((<any>dto).hasOwnProperty("_serviceType")) delete (<any>dto)["_serviceType"];
        return JSON.parse(JSON.stringify(dto));
    }

    public static deleteReturn(original: string | undefined | null) {
        if (!original) return "";
        return original.replace("\r\n", "").replace("\n", "");
    }

    public static setResponseProperties<T extends IResponseDto>(resultJson: string, type: { new(): T }): T {
        const obj = JSON.parse(resultJson); // 応答JSONをデシリアライズ

        // resultという名前のプロパティが存在することを確認し、
        if (obj.hasOwnProperty("result")) {

            const result = obj["result"]; // resultを取り出す
            delete obj["result"]; // objからresultを削除

            // objからrootレベルのキーを取得(payNowIdResponse, viewResultなど)
            const rootKeys: string[] = [];
            for (const key in obj) {
                if (obj.hasOwnProperty(key)) {
                    rootKeys.push(key);
                }
            }

            for (const key in result) {
                if (result.hasOwnProperty(key)) {
                    // rootレベルにキー重複がなければresultのプロパティをobjに追加
                    if (!rootKeys.some(value => value == key)) {
                        obj[key] = result[key];
                    }
                }
            }

            let response = <T>obj
            let copiedResponse = JSON.parse(JSON.stringify(response));
            MdkUtil.maskJson(copiedResponse);
            response.resultJson = JSON.stringify(copiedResponse); // resultJsonプロパティにマスクしたresponseのJSONを詰める
            return response;
        }

        return new type();
    }


}
