import {AbstractPayNowIdRequestDto} from "./AbstractPayNowIdRequestDto.js";
import type {IRequestDto} from "../../tgMdk/IRequestDto.js";


export class ChargeAddRequestDto extends AbstractPayNowIdRequestDto implements IRequestDto {

    readonly serviceType: string = "charge";
    readonly serviceCommand: string = "Add";

    constructor() {
        super("charge");
    }

    private _maskedLog: string | undefined;

    get maskedLog(): string | undefined {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }

}
