import {AbstractPayNowIdRequestDto} from "./AbstractPayNowIdRequestDto.js";
import type {IRequestDto} from "../../tgMdk/IRequestDto.js";


export class RecurringAddRequestDto extends AbstractPayNowIdRequestDto implements IRequestDto {

    readonly serviceType: string = "recurring";
    readonly serviceCommand: string = "Add";

    constructor() {
        super("recurring");
    }

    private _maskedLog: string | undefined;

    get maskedLog(): string | undefined {
        return this._maskedLog;
    }

    set maskedLog(value: string) {
        this._maskedLog = value;
    }

}
