import { MerchantConfig } from "./MerchantConfig.js";
import fetch, { Response } from "node-fetch";
export class HttpClient {
    _config;
    constructor(config) {
        this._config = config;
    }
    async execute(uri, json) {
        const headers = {
            'Content-Type': 'application/x-www-form-urlencoded',
            'User-Agent': MerchantConfig.userAgent
        };
        const controller = new AbortController();
        const timerId = setTimeout(() => {
            controller.abort();
        }, this._config.timeout * 1000);
        const options = {
            method: 'post',
            headers: headers,
            body: encodeURIComponent(json),
            signal: controller.signal
        };
        try {
            const res = await fetch(uri, options);
            return res.ok ? res : Promise.reject(res);
        }
        finally {
            clearTimeout(timerId);
        }
    }
}
//# sourceMappingURL=HttpClient.js.map