import { Buffer } from 'buffer';
import * as crypto from 'crypto';
export class MerchantUtility {
    static checkMessage(secretKey, msgBody, sContentHmac) {
        if (!secretKey || !msgBody || !sContentHmac) {
            return false;
        }
        const delimiter = ";v=";
        const hmacPos = sContentHmac.indexOf(delimiter);
        if (hmacPos < 0) {
            return false;
        }
        const paramHmac = sContentHmac.substring(hmacPos + delimiter.length);
        const hmacSHA256 = crypto.createHmac('sha256', Buffer.from(secretKey, 'hex'));
        hmacSHA256.update(Buffer.from(msgBody, 'utf8'));
        const hmac = hmacSHA256.digest('hex');
        return !(!hmac || hmac != paramHmac);
    }
}
//# sourceMappingURL=MerchantUtility.js.map