import { MdkDtoBase } from "./MdkDtoBase.js";
import { PayNowIdParam } from "./PayNowId/PayNowIdParam.js";
import { AccountParam } from "./PayNowId/AccountParam.js";
import { AccountBasicParam } from "./PayNowId/AccountBasicParam.js";
import { CardParam } from "./PayNowId/CardParam.js";
import { RecurringChargeParam } from "./PayNowId/RecurringChargeParam.js";
import { BankAccountParam } from "./PayNowId/BankAccountParam.js";
export class AbstractPaymentRequestDto extends MdkDtoBase {
    payNowIdParam;
    get accountId() {
        this.existAccountParam();
        return this.payNowIdParam?.accountParam?.accountId;
    }
    set accountId(value) {
        this.existAccountParam().accountId = value;
    }
    get createDate() {
        this.existAccountBasicParam();
        return this.payNowIdParam?.accountParam?.accountBasicParam?.createDate;
    }
    set createDate(value) {
        this.existAccountBasicParam().createDate = value;
    }
    get freeKey() {
        return this?.payNowIdParam?.freeKey;
    }
    set freeKey(value) {
        this.existPayNowIdParam().freeKey = value;
    }
    get memo1() {
        this.existPayNowIdParam();
        return this.payNowIdParam?.memo1;
    }
    set memo1(value) {
        this.existPayNowIdParam().memo1 = value;
    }
    get receiptData() {
        return this.payNowIdParam?.receiptData;
    }
    set receiptData(value) {
        this.existPayNowIdParam().receiptData = value;
    }
    existPayNowIdParam() {
        if (this.payNowIdParam == null) {
            this.payNowIdParam = new PayNowIdParam();
        }
        return this.payNowIdParam;
    }
    existAccountParam() {
        const payNowIdParam = this.existPayNowIdParam();
        if (payNowIdParam.accountParam == null) {
            payNowIdParam.accountParam = new AccountParam();
        }
        return payNowIdParam.accountParam;
    }
    existAccountBasicParam() {
        const accountParam = this.existAccountParam();
        if (accountParam.accountBasicParam == null) {
            accountParam.accountBasicParam = new AccountBasicParam();
        }
        return accountParam.accountBasicParam;
    }
    existCardParam() {
        const accountParam = this.existAccountParam();
        if (accountParam.cardParam == null) {
            accountParam.cardParam = new CardParam();
        }
        return accountParam.cardParam;
    }
    existRecurringChargeParam() {
        const accountParam = this.existAccountParam();
        if (accountParam.recurringChargeParam == null) {
            accountParam.recurringChargeParam = new RecurringChargeParam();
        }
        return accountParam.recurringChargeParam;
    }
    existBankAccountParam() {
        const accountParam = this.existAccountParam();
        if (accountParam.bankAccountParam == null) {
            accountParam.bankAccountParam = new BankAccountParam();
        }
        return accountParam.bankAccountParam;
    }
}
//# sourceMappingURL=AbstractPaymentRequestDto.js.map